#ifndef AhcReadout_HH
#define AhcReadout_HH

#include <iostream>
#include <fstream>

// online/inc/crc
#include "CrcReadout.hh"


class AhcReadout : public CrcReadout {

public:
  AhcReadout(unsigned b) : CrcReadout(b,0xac), _dacReset(false) {
  }

  AhcReadout(unsigned b, unsigned char c) : CrcReadout(b,c), _dacReset(false) {
  }

  virtual ~AhcReadout() {
  }

  virtual bool record(RcdRecord &r) {
    if(doPrint(r.recordType())) {
      std::cout << "AhcReadout::record()" << std::endl;
      r.RcdHeader::print(std::cout," ") << std::endl;
    }

    assert(CrcReadout::record(r));

    if(r.recordType()==RcdHeader::runStop ||
       r.recordType()==RcdHeader::runEnd) {

      SubInserter inserter(r);

      AhcVfeConfigurationData dummy;

      for(unsigned i(0);i<=21;i++) {
	if(_device[i]!=0) {
	  for(unsigned f(0);f<8;f++) {
	    
	    CrcLocationData<AhcVfeConfigurationData>
	      *b(inserter.insert< CrcLocationData<AhcVfeConfigurationData> >());
	    b->crateNumber(_location.crateNumber());
	    b->slotNumber(i);
	    b->crcComponent((CrcLocation::CrcComponent)f);
	    b->label(0);
	    
	    assert(_device[i]->writeAhcVfeConfigurationData((CrcLocation::CrcComponent)f,dummy,*b->data()));

	    if(_printLevel>4) b->print(std::cout);
	  }
	}
      }
    }

    // Needs to be added when doing continual slwData runs

    /*
    if(r.recordType()==RcdHeader::shutdown) {

      SubInserter inserter(r);

      AhcVfeSlowControlsData dummy;

      for(unsigned i(0);i<=21;i++) {
	if(_device[i]!=0) {
	  for(unsigned f(0);f<8;f++) {
	    
	    CrcLocationData<AhcVfeSlowControlsData>
	      *b(inserter.insert< CrcLocationData<AhcSlowControlsData> >());
	    b->crateNumber(_crateNumber);
	    b->slotNumber(i);
	    b->crcComponent((CrcLocation::CrcComponent)f);
	    b->label(0);
	    
	    assert(_device[i]->writeAhcVfeSlowControlsData((CrcLocation::CrcComponent)f,dummy,*b->data(),false));

	    if(_printLevel>4) b->print(std::cout);
	  }
	}
      }
    }
    */

    return true;
  }

  /*
  bool writeSlowControlsData(RcdRecord &r) {

    //assert(CrcReadout::writeSlowControlsData(r));

    SubInserter inserter(r);
    SubAccessor accessor(r);

    std::vector<const CrcLocationData<AhcVfeSlowControlsData>*>
      a(accessor.access< CrcLocationData<AhcVfeSlowControlsData> >());
    
    if(_printLevel>4) std::cout << "AhcReadout::record()  size of CrcLocationData<AhcVfeSlowControlsData> vector = "
				  << a.size() << " for slowControl" << std::endl;

    // Check for consistency; NB no FE broadcast possible due to readback
    for(unsigned j(0);j<a.size();j++) {
      assert(a[j]->crateNumber()==_crateNumber);
      assert(a[j]->crcComponent()<=CrcLocation::fe7);
      assert(a[j]->slotNumber()<=21 || a[j]->slotBroadcast());
    }

    // Check for slot broadcast
    for(unsigned j(0);j<a.size();j++) {
      if(a[j]->crateNumber()==_crateNumber              &&
	 a[j]->slotBroadcast()                          &&
	 a[j]->write()) {

	if(_printLevel>4) a[j]->print(std::cout);
	
	for(unsigned i(0);i<=21;i++) {
	  if(_device[i]!=0) {

	    CrcLocationData<AhcVfeSlowControlsData>
	      *b(inserter.insert< CrcLocationData<AhcVfeSlowControlsData> >());
	    b->crateNumber(a[j]->crateNumber());
	    b->slotNumber(_device[i]->slot());
	    b->crcComponent(a[j]->crcComponent());
	    b->write(false);
	    
	    assert(_device[i]->writeAhcVfeSlowControlsData(a[j]->crcComponent(),*a[j]->data(),*b->data(),_dacReset));

	    if(_printLevel>4) b->print(std::cout);
	  }
	}
      }
    }
    
    // Now do individual slots
    for(unsigned j(0);j<a.size();j++) {
      if(a[j]->crateNumber()==_crateNumber              &&
	!a[j]->slotBroadcast()                          &&
	 a[j]->write()) {

	if(_printLevel>4) a[j]->print(std::cout);

	if(_device[a[j]->slotNumber()]!=0) {
	  CrcLocationData<AhcVfeSlowControlsData>
	    *b(inserter.insert< CrcLocationData<AhcVfeSlowControlsData> >());
	  
	  b->crateNumber(a[j]->crateNumber());
	  b->slotNumber(a[j]->slotNumber());
	  b->crcComponent(a[j]->crcComponent());
	  b->write(false);
	  
	  assert(_device[a[j]->slotNumber()]->writeAhcVfeSlowControlsData(a[j]->crcComponent(),*a[j]->data(),*b->data(),_dacReset));

	  if(_printLevel>4) b->print(std::cout);
	}
      }
    }
    
    return true;
  }
  */

  /*
  bool writeFeConfigurationData(RcdRecord &r) {

    //assert(CrcReadout::writeFeConfigurationData(r));

    SubAccessor accessor(r);
    SubInserter inserter(r);

    std::vector<const CrcLocationData<AhcFeConfigurationData>*>
      femc(accessor.access< CrcLocationData<AhcFeConfigurationData> >());
    
    if(_printLevel>4) std::cout << "AhcReadout::record()  size of CrcLocationData<AhcFeConfigurationData> vector = "
				<< femc.size() << " for configurationStart" << std::endl;

    // First do slot broadcast
    for(unsigned j(0);j<femc.size();j++) {
      if(femc[j]->crateNumber()==_crateNumber && femc[j]->slotBroadcast()) {
	if(_printLevel>2) femc[j]->print(std::cout);

	// Loop over all the CRCs
	for(unsigned i(0);i<=21;i++) {
	  if(_device[i]!=0) {
	    if(femc[j]->crcComponent()==CrcLocation::feBroadcast) {
	      for(unsigned f(0);f<8;f++) {
		assert(_device[i]->writeAhcFeConfigurationData((CrcLocation::CrcComponent)f,*femc[j]->data()));
	      }
	    } else {
	      assert(_device[i]->writeAhcFeConfigurationData(femc[j]->crcComponent(),*femc[j]->data()));
	    }
	  }
	}
      }
    }

    // Next do FE broadcast 
    for(unsigned j(0);j<femc.size();j++) {
      if(femc[j]->crateNumber()==_crateNumber && !femc[j]->slotBroadcast()) {
	assert(femc[j]->slotNumber()<=21);
	
	if(femc[j]->crcComponent()==CrcLocation::feBroadcast) {
	  
	  if(_device[femc[j]->slotNumber()]!=0) {
	    if(_printLevel>2) femc[j]->print(std::cout) << std::endl;
	    for(unsigned f(0);f<8;f++) {
	      assert(_device[femc[j]->slotNumber()]->writeAhcFeConfigurationData((CrcLocation::CrcComponent)f,*femc[j]->data()));
	    }
	  }
	}
      }
    }


    // Finally do individual FE configurations
    for(unsigned j(0);j<femc.size();j++) {
      if(femc[j]->crateNumber()==_crateNumber) {
	if(!femc[j]->slotBroadcast() && femc[j]->crcComponent()!=CrcLocation::feBroadcast) {
	  if(_printLevel>2) femc[j]->print(std::cout);
	  assert(_device[femc[j]->slotNumber()]->writeAhcFeConfigurationData(femc[j]->crcComponent(),*femc[j]->data()));
	}
      }
    }


    std::vector<const CrcLocationData<AhcVfeConfigurationData>*>
      a(accessor.access< CrcLocationData<AhcVfeConfigurationData> >());
    
    if(_printLevel>4) std::cout << "AhcReadout::record()  size of CrcLocationData<AhcVfeConfigurationData> vector = "
				  << a.size() << " for configurationStart" << std::endl;

    // Check for consistency; NB no FE broadcast possible due to readback
    for(unsigned j(0);j<a.size();j++) {
      assert(a[j]->crateNumber()==_crateNumber);
      assert(a[j]->crcComponent()<=CrcLocation::fe7);
      assert(a[j]->slotNumber()<=21 || a[j]->slotBroadcast());
    }

    // Check for slot broadcast
    for(unsigned j(0);j<a.size();j++) {
      if(a[j]->crateNumber()==_crateNumber              &&
	 a[j]->slotBroadcast()                          &&
	 a[j]->write()) {

	if(_printLevel>4) a[j]->print(std::cout);
	
	for(unsigned i(0);i<=21;i++) {
	  if(_device[i]!=0) {

	    CrcLocationData<AhcVfeConfigurationData>
	      *b(inserter.insert< CrcLocationData<AhcVfeConfigurationData> >());
	    b->crateNumber(a[j]->crateNumber());
	    b->slotNumber(_device[i]->slot());
	    b->crcComponent(a[j]->crcComponent());
	    b->label(0);
	    
	    assert(_device[i]->writeAhcVfeConfigurationData(a[j]->crcComponent(),*a[j]->data(),*b->data()));

	    if(_printLevel>4) b->print(std::cout);
	  }
	}
      }
    }
    
    // Now do individual slots
    for(unsigned j(0);j<a.size();j++) {
      if(a[j]->crateNumber()==_crateNumber              &&
	!a[j]->slotBroadcast()                          &&
	 a[j]->write()) {

	if(_printLevel>4) a[j]->print(std::cout);

	if(_device[a[j]->slotNumber()]!=0) {
	  CrcLocationData<AhcVfeConfigurationData>
	    *b(inserter.insert< CrcLocationData<AhcVfeConfigurationData> >());
	  
	  b->crateNumber(a[j]->crateNumber());
	  b->slotNumber(a[j]->slotNumber());
	  b->crcComponent(a[j]->crcComponent());
	  b->label(0);
	  
	  assert(_device[a[j]->slotNumber()]->writeAhcVfeConfigurationData(a[j]->crcComponent(),*a[j]->data(),*b->data()));

	  if(_printLevel>4) b->print(std::cout);
	}
      }
    }

    return true;
  }

  bool readFeConfigurationData(RcdRecord &r) {

    //assert(CrcReadout::readFeConfigurationData(r));

    SubInserter inserter(r);

    for(unsigned i(0);i<=21;i++) {
      if(_device[i]!=0) {
	CrcLocation cl(_crateNumber,_device[i]->slot(),CrcLocation::vme,0);

	for(unsigned f(0);f<8;f++) {
          if(_config.slotFeEnable(i,f)) {
	    cl.crcComponent((CrcLocation::CrcComponent)f);
	    CrcLocationData<AhcFeConfigurationData>
	      *e(inserter.insert< CrcLocationData<AhcFeConfigurationData> >());
	    e->location(cl);
	    _device[i]->readAhcFeConfigurationData(cl.crcComponent(),*e->data());
	    if(_printLevel>4) e->print(std::cout);
	  }
	} 
      }
    }

    return true;
  }
  */

private:
  bool _dacReset;
};

#endif
