#ifndef TermIOs_HH
#define TermIOs_HH

#include <cstring>
#include <termios.h>

class TermIOs : public termios {

public:
  TermIOs() {
    memset(this,0,sizeof(TermIOs));
  };

  void print(ostream &o) const {
    o << "TermIOs print()" << std::endl;
    o << "  c_iflag = 0x" << hex << c_iflag << dec
      << "  c_oflag = 0x" << hex << c_oflag << dec
      << "  c_lflag = 0x" << hex << c_lflag << dec << std::endl;

    o << "  c_line = 0x" << hex << (unsigned)c_line << dec
      << "  c_cc[0-" << NCCS-1 << "] = " << hex;

    for(unsigned i(0);i<NCCS;i++) o << " 0x" << (unsigned)c_cc[i];
    o << dec << std::endl;

    o << " Input flag: c_iflag = 0x" << hex << c_iflag << dec << std::endl;

    o << " Output flag: c_oflag = 0x" << hex << c_oflag << dec << std::endl;

    o << " Control flag: c_cflag = 0x" << hex << c_cflag << dec << std::endl;
    unsigned bflag(c_cflag&CBAUD),baud(999999999);
    if(bflag==      B0) baud=      0;
    if(bflag==     B50) baud=     50;
    if(bflag==     B75) baud=     75;
    if(bflag==    B110) baud=    110;
    if(bflag==    B134) baud=    134;
    if(bflag==    B150) baud=    150;
    if(bflag==    B200) baud=    200;
    if(bflag==    B300) baud=    300;
    if(bflag==    B600) baud=    600;
    if(bflag==   B1200) baud=   1200;
    if(bflag==   B1800) baud=   1800;
    if(bflag==   B2400) baud=   2400;
    if(bflag==   B4800) baud=   4800;
    if(bflag==   B9600) baud=   9600;
    if(bflag==  B19200) baud=  19200;
    if(bflag==  B38400) baud=  38400;
    if(bflag==  B57600) baud=  57600;
    if(bflag== B115200) baud= 115200;
    if(bflag== B230400) baud= 230400;
    if(bflag== B460800) baud= 460800;
    if(bflag== B500000) baud= 500000;
    if(bflag== B576000) baud= 576000;
    if(bflag== B921600) baud= 921600;
    if(bflag==B1000000) baud=1000000;
    if(bflag==B1152000) baud=1152000;
    if(bflag==B1500000) baud=1500000;
    if(bflag==B2000000) baud=2000000;
    if(bflag==B2500000) baud=2500000;
    if(bflag==B3000000) baud=3000000;
    if(bflag==B3500000) baud=3500000;
    if(bflag==B4000000) baud=4000000;
    o << "  bflag = 0x" << hex << bflag << dec
      << ", baud rate = " << baud
      << "  c_ispeed = 0x" << hex << c_ispeed << dec
      << "  c_ospeed = 0x" << hex << c_ospeed << dec << std::endl;

    unsigned sflag(c_cflag&CSIZE),size(999999999);
    if(sflag==CS5) size=5;
    if(sflag==CS6) size=6;
    if(sflag==CS7) size=7;
    if(sflag==CS8) size=8;
    o << "  sflag = 0x" << hex << sflag << dec
      << ", size = " << size << " data bits" << std::endl;
    if((c_cflag&CREAD)==0) o << "  Read disabled" << std::endl;
    else                   o << "  Read enabled" << std::endl;
    if((c_cflag&CLOCAL)==0) o << "  Non-local" << std::endl;
    else                    o << "  Local" << std::endl;

    o << "  Protocol";
    if((c_cflag&CSTOPB)==0) o << " 1 stop bit";
    else                    o << " 2 stop bits";
    if((c_cflag&PARENB)==0) o << ", parity disabled";
    else {
      o << ", parity enabled";
      if((c_cflag&PARODD)==0) o << ", even parity";
      else                    o << ", odd parity";
    }
    o << std::endl;
    if((c_cflag&CRTSCTS)==0) o << "  Hardware flow control disabled" << std::endl;
    else                     o << "  Hardware flow control enabled" << std::endl;
    if((c_cflag&HUPCL)==0) o << "  Hangup disabled" << std::endl;
    else                   o << "  Hangup enabled" << std::endl;


    o << " Local flag: c_lflag = 0x" << hex << c_lflag << dec << std::endl;
    if((c_lflag&ICANON)==0) o << "  Non-canonical";
    else                    o << "  Canonical";
    o << std::endl;
  }
};

#endif
