#ifndef CercVmeSerialCommandBits_HH
#define CercVmeSerialCommandBits_HH

#include "CercVmeSerialCommand.hh"

template <unsigned NumberOfBits>
class CercVmeSerialCommandBits : public CercVmeSerialCommand<NumberOfBits> {

public:
  CercVmeSerialCommandBits(Target t, Designator d)
    : CercVmeSerialCommand<NumberOfBits>(t,d) {
  }

  unsigned bits() const {
    return _data[0]>>(32-NumberOfBits);
  }

  void bits(unsigned b) {
    unsigned mask(0xffffffff>>(32-NumberOfBits));
    _data[0]=(b&mask)<<(32-NumberOfBits);
  }
};

#endif
