#ifndef CrcSerialCommand_HH
#define CrcSerialCommand_HH

#include <iostream>
#include <string>

#include "CrcSerialHeader.hh"


template <unsigned NumberOfBits>
class CrcSerialCommand : public CrcSerialHeader {

public:
  CrcSerialCommand(Target t, Designator d)
    : CrcSerialHeader(t,d,NumberOfBits) {
    memset(_data,0,4*((NumberOfBits+31)/32));
  }

  const unsigned* data() const {
    return _data;
  }

  unsigned* data() {
    return _data;
  }

  void print(std::ostream& o, std::string s="") const {
    o << s << "CrcSerialCommand<" << NumberOfBits << ">" << std::endl;
    CrcSerialHeader::print(o,s+" ");
    for(unsigned i(0);i<(NumberOfBits+31)/32;i++) {
      o << s << " Data word " << std::setw(4) << i << " = "
	<< std::setw(10) << printHex(_data[i]) << std::endl;
    }
  }


protected:
  unsigned _data[(NumberOfBits+31)/32];
};

#endif
