#ifndef CrcSerialCommandI2CControl_HH
#define CrcSerialCommandI2CControl_HH

#include "CrcSerialCommand.hh"

class CrcSerialCommandI2CControl : public CrcSerialCommand<17> {

public:
  CrcSerialCommandI2CControl(Target t, Designator d)
    : CrcSerialCommand<17>(t,d) {
  }

  void set(unsigned char a, unsigned char d, bool r=true) {
    _data[0]=((a<<8)+d)<<15;
    if(r) _data[0]|=0x80000000;
  }
};

#endif
