#ifndef CrcSerialHeader_HH
#define CrcSerialHeader_HH

#include <iostream>
#include <string>


class CrcSerialHeader {

public:
  enum Designator {
    designator00,designator01,designator02,designator03,
    designator04,designator05,designator06,designator07,
    designator08,designator09,designator10,designator11,
    designator12,designator13,designator14,designator15,
    designator16,designator17,designator18,designator19,
    designator20,designator21,designator22,designator23,
    designator24,designator25,designator26,designator27,
    designator28,designator29,designator30,designator31,

    // FED
    fedBeSoftwareTrigger=8,
    beSoftwareReset=9,

    feConfigurationData=0,
    feSoftwareReset=12,

    // CERC
    // Target = All
    resetLevel2=0,
    resetLevel3,
    firmwareId,
    lm82Control,
    lm82Status,
    
    // Target = BE
    beConfigurationRWData=8,
    beConfigurationROData,
    beFlushData,
    beTriggerMaster,

    beNumberOfQdrEvents=16,
    beQDRStatus,
    beSoftwareTrigger=23,

    // Target = BE-trigger
    beTrgConfigurationRWData=8,
    beTrgConfigurationROData,

    beTrgStatus=16,
    beTrgReset,
    beTrgSoftwareTrigger=23,

    // Target = FE
    feConfigurationRWData=8,
    feConfigurationROData,
    feFakeEventData,
    feMode,
    
    feSoftwareTrigger=23,

    endOfDesignatorEnum
  };

  CrcSerialHeader() : _length(0), _designator(0x81), _target(0) {
  }

  unsigned char* packet() {
    return &_designator;
  }

  bool readback() const {
    if((_designator&0x40)==0) return false;
    return true;
  }

  void readback(bool r) {
    if(r) _designator|=  0x40;
    else  _designator&= ~0x40;
  }

  Designator designator() const {
    return static_cast<Designator>((_designator>>1)&0x1f);
  }

  void designator(Designator d) {
    _designator&=0xc1;
    _designator|=((static_cast<unsigned>(d)&0x1f)<<1);
  }

  unsigned length() const {
    return _length;
  }

  void length(unsigned l) {
    _length=l;
  }

  void print(std::ostream &o, std::string s="") const {
    o << s << "CrcSerialHeader::print()" << std::endl;

    if(readback()) o << s << " Readback bit set" << std::endl;
    else           o << s << " Readback bit not set" << std::endl;

    o << s << " Designator = " << designator() << " = 0x"
      << hex << designator() << dec << std::endl
      << s << " Length = " << _length << " = 0x" << hex << _length 
      << dec << std::endl;
  }


protected:
  unsigned short _length;
  unsigned char _designator;
  unsigned char _target;
};

#endif
