//
// $Id: DhcSerialCommand.hh,v 1.1 2008/06/27 10:34:05 meyern Exp $
//

#ifndef DhcSerialCommand_HH
#define DhcSerialCommand_HH

#include <iostream>
#include <string>

#include "UtlPrintHex.hh"

#include "DhcSerialHeader.hh"


template <unsigned NumberOfBytes>
class DhcSerialCommand : public DhcSerialHeader {

public:
  DhcSerialCommand(Register r, Command c, char a = 0, char d = 0)
    : DhcSerialHeader(r, c, a, d, NumberOfBytes) {  
    assert(NumberOfBytes==0 || NumberOfBytes==1 || NumberOfBytes==8);
  }

  void data(const unsigned char* d) {
    for (unsigned i=0; i<NumberOfBytes; i++)
      _data[(i+2)/4].byte(3-(i+2)%4, d[i]);
  }

  unsigned char data() const {
    // only 1 byte reads
    return _data[0].byte(1);
  }

  void print(std::ostream &o, std::string s="") const {
    o << s << "DhccSerialCommand::print()  Words = 0x " << std::hex;

    const unsigned *b((const unsigned *const)this);
    for(unsigned i(0); i<(NumberOfBytes+4)/4; i++)
      o << static_cast<unsigned>(b[i]) << " ";
    o << std::dec << std::endl;

    if(valid()) o << s << " Header bits are valid" << std::endl;
    else        o << s << " Header bits are invalid" << std::endl;

    unsigned short r((unsigned short)reg());
    o << s << " Register = " << printHex(r,false) << " = ";
    if(r<endOfRegisterEnum)
      o << _registerName[r] << std::endl;
    else                  o << "unknown" << std::endl;

    unsigned short c((unsigned short)cmd());
    o << s << " Command  = " << printHex(c,false) << " = ";
    if(c<endOfCommandEnum)
      o << _commandName[c] << std::endl;
    else                  o << "unknown" << std::endl;

    unsigned short a((unsigned short)chip());
    o << s << " DCALAD   = " << printHex(a,false) << std::endl;
  }

};

#endif // DhcSerialCommand_HH
