#ifndef DheReadout_HH
#define DheReadout_HH

#include <iostream>
#include <fstream>

#include "CrcReadout.hh"
#include "CrcLocationData.hh"
#include "DheVfeConfigurationData4.hh"
#include "DheTriggerData.hh"
#include "DheEventData.hh"


class DheReadout : public CrcReadout {

public:
  DheReadout(unsigned b) : CrcReadout(b,0xde) {
  }

  DheReadout(unsigned b, unsigned char c) : CrcReadout(b,c) {
  }

  virtual ~DheReadout() {
  }

  virtual bool record(RcdRecord &r) {
    if(doPrint(r.recordType())) {
      std::cout << "DheReadout::record()" << std::endl;
      r.RcdHeader::print(std::cout," ") << std::endl;
    }

    SubInserter inserter(r);

    UtlPack tid;
    tid.halfWord(1,SubHeader::ahc);
    tid.byte(2,_location.crateNumber());
    DaqTwoTimer *t(inserter.insert<DaqTwoTimer>(true));
    t->timerId(tid.word());

    if(r.recordType()==RcdHeader::runStart) {
#ifdef DHE_CONTROL_SKT
      // DheRunData
#endif
    }

    if(r.recordType()==RcdHeader::configurationStart) {
      SubAccessor accessor(r);

      std::vector<const CrcReadoutConfigurationData*>
	bc(accessor.access< CrcReadoutConfigurationData>());
      
      for(unsigned j(0);j<bc.size();j++) {
	if(bc[j]->crateNumber()==_location.crateNumber()) {
	  _config=*(bc[j]);
	  if(doPrint(r.recordType(),1)) _config.print(std::cout," ") << std::endl;
	}
      }

      std::vector<const CrcLocationData<DheVfeConfigurationData4>*>
	v(accessor.access<CrcLocationData<DheVfeConfigurationData4> >());
      
      if(doPrint(r.recordType(),2)) {
	std::cout << " Number of DheVfeConfigurationData4 subrecords found = "
		  << v.size() << std::endl;

	for(unsigned i(0);i<v.size();i++) {
	  v[i]->print(std::cout," ") << std::endl;
	}
      }
      
      assert(doDheVfeConfigurationData(v,r));
    }

#ifdef DHE_CONTROL_SKT
    if(r.recordType()==RcdHeader::trigger) {
      if(_config.fePeriod()>0 && (_nEvents%_config.fePeriod())==0) {
	DheTriggerData d;
	d.triggerNumber(_nEvents);

	if(doPrint(r.recordType(),2)) d.print(std::cout," ") << std::endl;
	inserter.insert(d);
      }
    }

    if(r.recordType()==RcdHeader::event) {
      DheEventData d;

      if(doPrint(r.recordType(),2)) d.print(std::cout," ") << std::endl;
      inserter.insert(d);
    }
#endif

    if(r.recordType()==RcdHeader::runEnd) {
#ifdef DHE_CONTROL_SKT
      // DheRunData
#endif

      CrcLocationData<DheVfeConfigurationData4> defaultData(_location);
      defaultData.slotBroadcast(true);
      defaultData.crcComponent(CrcLocation::feBroadcast);
      defaultData.label(1);
      std::vector<const CrcLocationData<DheVfeConfigurationData4>*> v;
      v.push_back(&defaultData);

      assert(doDheVfeConfigurationData(v,r));
    }
    
    bool reply(CrcReadout::record(r));
    
    // Close off overall timer
    t->setEndTime();
    if(doPrint(r.recordType())) t->print(std::cout," ") << std::endl;
    
    return reply;
  }


  bool doDheVfeConfigurationData(std::vector<const CrcLocationData<DheVfeConfigurationData4>*> &v, RcdRecord &r) {

    // Cannot write multiple times as lose previous values
    // Find single value for each slot/FE
    DheVfeConfigurationData4 writeData[22][8];

    // First look for slot and FE broadcast
    for(unsigned i(0);i<v.size();i++) {      
      if(v[i]->label()==1) {
	assert(v[i]->crateNumber()==_crateNumber);
	if(v[i]->slotBroadcast() && v[i]->crcComponent()==CrcLocation::feBroadcast) {
	  for(unsigned s(0);s<=21;s++) {
	    for(unsigned f(0);f<8;f++) {
	      writeData[s][f]=*(v[i]->data());
	    }
	  }
	}
      }
    }

    // Look for slot broadcast and not FE broadcast
    for(unsigned i(0);i<v.size();i++) {      
      if(v[i]->label()==1) {
	assert(v[i]->crateNumber()==_crateNumber);
	if(v[i]->slotBroadcast() && v[i]->crcComponent()<=CrcLocation::fe7) {
	  for(unsigned s(0);s<=21;s++) {
	    writeData[s][v[i]->crcComponent()]=*(v[i]->data());
	  }
	}
      }
    }
	  
    // Look for not slot broadcast and FE broadcast
    for(unsigned i(0);i<v.size();i++) {      
      if(v[i]->label()==1) {
	assert(v[i]->crateNumber()==_crateNumber);
	if(!v[i]->slotBroadcast() && v[i]->crcComponent()==CrcLocation::feBroadcast) {
	  unsigned s(v[i]->slotNumber());
	  assert(s>=0 && s<=21);

	  for(unsigned f(0);f<8;f++) {
	    writeData[s][f]=*(v[i]->data());
	  }
	}
      }
    }

    // Look for not slot broadcast and not FE broadcast
    for(unsigned i(0);i<v.size();i++) {
      if(v[i]->label()==1) {
	assert(v[i]->crateNumber()==_crateNumber);
	if(!v[i]->slotBroadcast() && v[i]->crcComponent()<=CrcLocation::fe7) {
	  unsigned s(v[i]->slotNumber());
	  assert(s>=0 && s<=21);

	  writeData[s][v[i]->crcComponent()]=*(v[i]->data());
	}
      }
    }

    // Now load
    SubInserter inserter(r);

    CrcLocationData<DheVfeConfigurationData4> readData;
    readData.crateNumber(_crateNumber);

    if(doPrint(r.recordType(),1)) 
      _config.print(std::cout," ") << std::endl;

    for(unsigned s(2);s<=21;s++) {
      if(_device[s]!=0 && _config.slotEnable(s)) {
	for(unsigned f(0);f<8;f++) {
	  if(_config.slotFeEnable(s,f)) {
	    if(doPrint(r.recordType(),2)) writeData[s][f].print(std::cout," ") << std::endl;

#ifdef DHE_CONTROL_SKT
#else
	    /* CRC use needs debugging
	    assert(_device[s]->writeDheVfeConfigurationData((CrcLocation::CrcComponent)f,
	                                                    writeData[s][f],
							    *(readData.data())));
	    */
#endif

	    readData.slotNumber(s);
	    readData.crcComponent((CrcLocation::CrcComponent)f);
	    readData.label(2);
	    inserter.insert(readData);
	    
	    if(doPrint(r.recordType(),2)) readData.print(std::cout," ") << std::endl;
	  }
	}
      }
    }

    return true;
  }


private:
};

#endif
