#ifndef DioBuffer_HH
#define DioBuffer_HH

#include <cassert>
#include <queue>

#include "ShmObject.hh"

#include "SemClosed.hh"

#include "DioBufferStatus.hh"
#include "DioProducer.hh"
#include "DioConsumer.hh"

#ifndef DIO_SEND_OBJECTS

template<class Type> class DioBuffer
  : public DioConsumer<Type>, public DioProducer<Type> {

public:
  DioBuffer(key_t k) : _semCounter(), _semQueueLock(1), _largestQueueSize(0),
		       _shm(k), _status(_shm.payload()) {

    std::cout << "DioBuffer<Type>::ctor ";
    std::cout << _semQueueLock.value();
    //t.print();
    std::cout << std::endl;

    _status->reset();
  }
    
  virtual ~DioBuffer() {
    std::cout << "DioBuffer<Type>::dtor" << std::endl;
  }

  virtual DioControl push(DioTypeHolder<Type> &h) {

    //    std::cout << "DioBuffer<Type>::push queue lock value = ";
    //    std::cout << _semQueueLock.value();
    //t.print();
    //    std::cout << std::endl;
    
    _status[0].updateInputTime();
    _semQueueLock--;
    _status[0].updateOutputTime();
    _queue.push(h);
    _status[0].value(_queue.size());

    int n(_queue.size());
    if(_largestQueueSize<n) {
      _largestQueueSize=n;
      std::cout << "DioBuffer<Type>::push largest queue size incremented to "
		<< _largestQueueSize << hex << " = 0x"
		<< _largestQueueSize << dec << std::endl;
    }
    return h.control();
  }

  virtual void poc() {
    _semQueueLock++;
    _semCounter++;
  }

  virtual DioTypeHolder<Type>& pull() {
    _status[1].updateInputTime();
    _semCounter--;
    _semQueueLock--;
    _status[1].updateOutputTime();
    _status[1].value(_queue.size());
    
    assert(_queue.size()>0);
    return _queue.front();
  }

  virtual void pop() {
    _queue.pop();
    _semQueueLock++;
  }

private:
  SemOpen _semQueueLock;
  SemClosed _semCounter;
  std::queue< DioTypeHolder<Type> > _queue;
  int _largestQueueSize;

  ShmObject<DioBufferStatus,2> _shm;
  DioBufferStatus* const _status;
};

#endif
#endif
