#ifndef DioConnector_HH
#define DioConnector_HH

#include "DioTypeHolder.hh"
#include "DioProducer.hh"
#include "DioConsumer.hh"
#include "SemOpen.hh"

template<class Type> class DioConnector
  : public DioConsumer<Type>, public DioProducer<Type> {

public:
  DioConnector() : _semObjectInp(0), _semObjectOut(1) {
  }
    
  virtual ~DioConnector() {
  }

  virtual DioControl push(DioTypeHolder<Type>& h) {
    _semObjectOut--;
    _holder=h;
    return h.control();
  }

  virtual void poc() {
    _semObjectInp++;
  }

  virtual DioTypeHolder<Type>& pull() {
    _semObjectInp--;
    return _holder;
  }

  virtual void pop() {
    _semObjectOut++;
  }

  bool newData() const {
    return _semObjectInp.value()>0;
  }

private:
  SemOpen _semObjectInp;
  SemOpen _semObjectOut;
  DioTypeHolder<Type> _holder;
};

#endif
