#ifndef DioControl_HH
#define DioControl_HH

#include <string>

class DioControl {

public:
  enum DioStatus {
    ok,
    shutdown,
    fatalError,
    endOfDioStatusEnum
  };

  DioControl() : _status(ok) {
  }

  DioControl(DioStatus s) : _status(s) {
  }

  DioStatus status() const {
    return _status;
  }

  void status(DioStatus s) {
    _status=s;
  }

  void worstStatus(DioStatus s) {
    if(s>_status) _status=s;
  }

  /*
  std::string statusName(DioStatus s) {
    return statusName[s];
  }
  */
  static const std::string statusName[endOfDioStatusEnum];

private:
  DioStatus _status;
};

const std::string DioControl::statusName[]={"ok","shutdown","fatalError"};

#endif
