#ifndef DioDefaultConsumer_HH
#define DioDefaultConsumer_HH

#include "DioConsumer.hh"

template<class Type> class DioDefaultConsumer : public DioConsumer<Type> {

public:
  virtual DioControl push(DioTypeHolder<Type>& h) {
    Type *t(h.pointer());
    if(t==0) std::cout
      << "DioDefaultConsumer<T>::push() null pointer" << std::endl;
    h.destroy();

    DioControl c(h.control());
    if(c.status()!=DioControl::ok) std::cout
      << "DioDefaultConsumer<T>::push() status = " << c.status()
      << " = " << DioControl::statusName[c.status()] << std::endl;
    return c;
  }

private:
};

#endif
