#ifndef DioMultiConsumer_HH
#define DioMultiConsumer_HH

#include "DioProducer.hh"
#include "DioConnector.hh"


template<class Type> class DioMultiConsumer : public DioProducer<Type> {

public:
  DioMultiConsumer(unsigned n) : _numberOfConsumers(n), _connector(0) {
    if(_numberOfConsumers==0) return;
    _connector=new DioConnector<Type>[_numberOfConsumers];
  }
    
  virtual ~DioMultiConsumer() {
    delete [] _connector;
  }


  virtual DioTypeHolder<Type>& pull() {
    for(unsigned i(1);i<_numberOfConsumers;i++) {
      _connector[i].pull().destroy();
    }
    return _connector[0].pull();
  }


  virtual void pop() {
    for(unsigned i(0);i<_numberOfConsumers;i++) {
      _connector[i].pop();
    }
  }


  virtual DioConsumer<Type>& consumer(unsigned n) {
    if(n>_numberOfConsumers) n=0;
    return _connector[n];
  }


protected:
  const unsigned _numberOfConsumers;
  DioConnector<Type> *_connector;
};

#endif
