#ifndef DioMultiProducerOld_HH
#define DioMultiProducerOld_HH

#include "DioProducer.hh"
#include "DioConsumer.hh"
#include "DioConnector.hh"


template<class Type> class DioMultiProducerOld : public DioConsumer<Type> {

public:
  DioMultiProducerOld(unsigned n) : _numberOfProducers(n), _connector(0) {
    if(_numberOfProducers==0) return;
    _connector=new DioConnector<Type>[_numberOfProducers];
  }
    
  virtual ~DioMultiProducerOld() {
    delete [] _connector;
  }

  virtual DioControl push(DioTypeHolder<Type>& h) {
    const Type *t(h.pointer());

    for(unsigned i(1);i<_numberOfProducers;i++) {
      DioTypeHolder<Type> z(0,h.control());
      z.create(t);
      _connector[i].push(z);
    }

    // Must do this last as otherwise the object might be deleted too fast
    _connector[0].push(h);
    return h.control();
  }

  virtual void poc() {
    for(unsigned i(0);i<_numberOfProducers;i++) {
      _connector[i].poc();
    }
  }

  virtual DioProducer<Type>& producer(unsigned n) {
    if(n>_numberOfProducers) n=0;
    return _connector[n];
  }


protected:
  const unsigned _numberOfProducers;
  DioConnector<Type> *_connector;
};

#endif
