#ifndef DioSocketProducer_HH
#define DioSocketProducer_HH

#include "DuplexSocket.hh"
#include "DioProducer.hh"

#ifdef DIO_SEND_OBJECTS

template<class Type> class DioSocketProducer {

public:

  /*
  virtual T pull() {
    T t;
    return t;
  }
  */

  virtual int hsup(DioConsumer<Type> &c) = 0;

  virtual int test() {
    return 0;
  }

private:
};

#endif
#ifndef DIO_SEND_OBJECTS

template<class Type> class DioSocketProducer : public DioProducer<Type> {

public:
  DioSocketProducer(int port, bool singleSocket=true) 
    : _duplexSocket(port,singleSocket) {
  }

  DioSocketProducer(std::string host, int port, int tries = 0) 
    : _duplexSocket(host,port,tries) {
  }

  virtual ~DioSocketProducer() {
  }

  virtual DioTypeHolder<Type>& pull() {
    DioControl c;

    //    cerr << "Receiving Control" << endl;
    _duplexSocket.recv(&c,1);
 
    //cerr << "Receiving Type" << endl;
    Type *t(new Type());
    _duplexSocket.recv(t,1);
    _holder=DioTypeHolder<Type>(t,c);
    return _holder;
  }

private:
  DuplexSocket _duplexSocket;
  DioTypeHolder<Type> _holder;
};

#endif
#endif
