#ifndef DioTypeHolder_HH
#define DioTypeHolder_HH

#include "DioControl.hh"

#ifndef DIO_SEND_OBJECTS

template <class Type> class DioTypeHolder {

public:
  DioTypeHolder() : _pointer(0) {
  }

  DioTypeHolder(Type* t, const DioControl &c)
    : _pointer(t), _control(c) {
  }

  Type* pointer() const {
    return _pointer;
  }

  void pointer(Type *t) {
    _pointer=t;
  }

  Type& object() const {
    return *_pointer;
  }

  DioControl control() const {
    return _control;
  }

  void control(const DioControl &c) {
    _control=c;
  }

  void create(const Type *t=0) {
    //delete _pointer;
    if(t==0) _pointer=new Type;
    else     _pointer=new Type(*t);
  }

  void destroy() {
    delete _pointer;
    _pointer=0;
  }

private:
  Type *_pointer;
  DioControl _control;
};

#endif
#endif
