#ifndef DvrAhcSlw_HH
#define DvrAhcSlw_HH

#include <iostream>
#include <fstream>

// dual/inc/rcd
#include "RcdUserRW.hh"

// dual/inc/sub
#include "SubInserter.hh"
#include "SubAccessor.hh"

#include "AhcVfeSlowControlsData.hh"
#include "AhcVfeSlowControlsFile.hh"


class DvrAhcSlw : public DvrCrcSlw {

public:
  DvrAhcSlw() : DvrCrcSlw(0xac) {
  }

  virtual ~DvrAhcSlw() {
  }

  bool record(RcdRecord &r) {

    // Only set limits once per job
    if(_done) return true;

    assert(DvrCrcSlw::record(r));

    // Check record type
    switch (r.recordType()) {

    // Slow control
    case RcdHeader::slowControl: {

      SubInserter inserter(r);

      CrcLocationData<AhcVfeSlowControlsData>
        *b(inserter.insert< CrcLocationData<AhcVfeSlowControlsData> >(true));
      b->crateNumber(_crateNumber);
      b->slotNumber(12);
      b->crcComponent(CrcLocation::fe1);
      b->label(1);

      AhcVfeSlowControlsFile f;
      assert(f.read("DACvalues.dat",*b->data()));

      if(_printLevel>0) {
        std::cout << "DvrAhcSlw::record()  CrcLocationData<AhcVfeSlowControlsData> subrecord"
                  << std::endl;
        b->print(std::cout," ");
      }

      _done=true;
      break;
    }

    default: {
      break;
    }
    };

    return true;
  }


private:
};

#endif
