#ifndef DvrCrcNoise_HH
#define DvrCrcNoise_HH

#include <iostream>
#include <fstream>

// dual/inc/daq
#include "DaqRunStart.hh"
#include "DaqConfigurationStart.hh"
#include "DaqSpillStart.hh"

// dual/inc/rcd
#include "RcdUserRW.hh"

// dual/inc/sub
#include "SubInserter.hh"
#include "SubAccessor.hh"


class DvrCrcNoise : public RcdUserRW {

public:
  DvrCrcNoise(unsigned char c) : RcdUserRW(), _crateNumber(c) {
  }

  DvrCrcNoise(unsigned char c, unsigned p) : RcdUserRW(p), _crateNumber(c) {
  }

  virtual ~DvrCrcNoise() {
  }

  virtual bool record(RcdRecord &r) {

    // Check record type
    switch (r.recordType()) {


    // Run start 
    case RcdHeader::runStart: {

      // Access the DaqRunStart
      SubAccessor accessor(r);
      std::vector<const DaqRunStart*> v(accessor.extract<DaqRunStart>());
      assert(v.size()==1);

      DaqRunStart *w((DaqRunStart*)v[0]);
      w->runType(DaqRunStart::test);
      w->runSubtype(3);
      w->maximumNumberOfConfigurationsInRun(50);
      w->maximumNumberOfSpillsInRun(0xffffffff);
      w->maximumNumberOfEventsInRun(0xffffffff);
      w->maximumNumberOfBytes(1800000000);

      if(_printLevel>0) {
        std::cout << "DvrCrcNoise::record()  DaqRunStart subrecord"
                  << std::endl;
        v[0]->print(std::cout," ");
      }

      break;
    }


    // Configuration start is used to set up system
    case RcdHeader::configurationStart: {

      // Access the DaqConfigurationStart
      SubAccessor accessor(r);
      std::vector<const DaqConfigurationStart*> v(accessor.extract<DaqConfigurationStart>());
      assert(v.size()==1);

      DaqConfigurationStart *w((DaqConfigurationStart*)v[0]);
      w->maximumNumberOfSpillsInConfiguration(10);
      w->maximumNumberOfEventsInConfiguration(0xffffffff);

        v[0]->print(std::cout," ");

      if(_printLevel>2) {
        std::cout << "DvrCrcNoise::record()  DaqConfigurationStart subrecord"
                  << std::endl;
        v[0]->print(std::cout," ");
      }

      SubInserter inserter(r);

      // Add readout control
      CrcReadoutConfigurationData
	*b(inserter.insert<CrcReadoutConfigurationData>());
      *b=CrcReadoutConfigurationData();
      b->vmePeriod(1);
      b->bePeriod(1);
      b->beTrgPeriod(0);
      b->fePeriod(1);
      b->beTrgMode(0);
      b->vlinkMode(3);

      //b->clearBeTrgTrigger(true);
      //b->beTrgSoftTrigger(true);
      //b->beTrgPollNumber(1000);

      b->beSoftTrigger(true);
      //b->feBroadcastSoftTrigger(true);
      //b->feSoftTrigger(0,true);
      //b->feSoftTrigger(1,true);
      //b->feSoftTrigger(2,true);
      //b->feSoftTrigger(3,true);
      //b->feSoftTrigger(4,true);
      //b->feSoftTrigger(5,true);
      //b->feSoftTrigger(6,true);
      //b->feSoftTrigger(7,true);

      if(_printLevel>2) b->print(std::cout," ") << std::endl;
      

      if(b->clearBeTrgTrigger()) {
	b->beTrgPeriod(1);

            CrcLocationData<CrcBeTrgConfigurationData>
              *bt(inserter.insert< CrcLocationData<CrcBeTrgConfigurationData> >());
            bt->crateNumber(_crateNumber);
            bt->slotBroadcast(true);
            bt->crcComponent(CrcLocation::beTrg);
            bt->label(1);

            *bt->data()=CrcBeTrgConfigurationData();
            //
            //bt->data()->inputEnable(1<<0); // DevBoard
            bt->data()->inputEnable(1<<24); // Trg osc

            //bt->data()->outputEnable(1); // Bit 0 enables J0 fanout
            //bt->data()->oscillationPeriod(40000000); // 1 sec
            //bt->data()->oscillationPeriod(4000000); // 0.1 sec
            bt->data()->oscillationPeriod(400000); // 0.01 sec
            //bt->data()->oscillationPeriod(40000); // 0.001 sec
            bt->print(std::cout) << std::endl;
 
      }










      // BE
      CrcLocationData<CrcBeConfigurationData>
	*c(inserter.insert< CrcLocationData<CrcBeConfigurationData> >());
      c->crateNumber(_crateNumber);
      c->slotBroadcast(true);
      c->crcComponent(CrcLocation::be);
      c->label(1);
      
      *c->data()=CrcBeConfigurationData();
      c->data()->mode(0x02);
      c->data()->test(0x00);
      c->data()->testLength(0);
      c->data()->trgEnables(0x2ff); // 0x1ff for J0, 0x2ff for internal
      if(_printLevel>2) c->print(std::cout," ") << std::endl;

      feConfigurationData(r);

      break;
    }

    case RcdHeader::spillStart: {

      // Access the DaqSpillStart
      SubAccessor accessor(r);
      std::vector<const DaqSpillStart*> v(accessor.extract<DaqSpillStart>());
      assert(v.size()==1);

      DaqSpillStart *w((DaqSpillStart*)v[0]);
      w->maximumNumberOfEventsInSpill(511);

      if(_printLevel>4) {
        std::cout << "DvrCrcNoise::record()  DaqSpillStart subrecord"
                  << std::endl;
        v[0]->print(std::cout," ");
      }

      break;
    }

    default: {
      break;
    }
    };

    return true;
  }

  virtual bool feConfigurationData(RcdRecord &r) {
    SubInserter inserter(r);

    // FE
    CrcLocationData<CrcFeConfigurationData>
      *d(inserter.insert< CrcLocationData<CrcFeConfigurationData> >());
    d->crateNumber(_crateNumber);
    d->slotBroadcast(true);
    d->crcComponent(CrcLocation::feBroadcast);
    d->label(1);
    
    *d->data()=CrcFeConfigurationData();
    
    unsigned nadc=18;
    d->data()->holdStart(1);
    d->data()->holdWidth(nadc*4*700);
    d->data()->vfeMplexClockPulses(nadc);
    
    if(_printLevel>2) d->print(std::cout) << std::endl;

    return true;
  }


protected:
  unsigned char _crateNumber;
};

#endif
