#ifndef DvrCrcSlw_HH
#define DvrCrcSlw_HH

#include <iostream>
#include <fstream>

// dual/inc/daq
#include "DaqRunStart.hh"
#include "DaqConfigurationStart.hh"
#include "DaqSpillStart.hh"

// dual/inc/rcd
#include "RcdUserRW.hh"

// dual/inc/sub
#include "SubInserter.hh"
#include "SubAccessor.hh"


class DvrCrcSlw : public RcdUserRW {

public:
  DvrCrcSlw(unsigned char c) : RcdUserRW(), _crateNumber(c), _done(false) {
  }

  virtual ~DvrCrcSlw() {
  }

  virtual bool record(RcdRecord &r) {

    // Only set limits once per job
    if(_done) return true;

    // Check record type
    switch (r.recordType()) {

    // Slow control
    case RcdHeader::slowControl: {

      SubInserter inserter(r);

      CrcLocationData<CrcAdm1025SlowControlsData>
        *b(inserter.insert< CrcLocationData<CrcAdm1025SlowControlsData> >());
      b->crateNumber(_crateNumber);
      b->slotBroadcast(true);
      b->crcComponent(CrcLocation::vme);
      b->label(1);

      *b->data()=CrcAdm1025SlowControlsData();

      if(_printLevel>0) {
        std::cout << "DvrCrcSlw::record()  CrcLocationData<CrcAdm1025SlowControlsData> subrecord"
                  << std::endl;
        b->print(std::cout," ");
      }

      CrcLocationData<CrcLm82SlowControlsData>
        *u(inserter.insert< CrcLocationData<CrcLm82SlowControlsData> >());
      u->crateNumber(_crateNumber);
      u->slotBroadcast(true);
      u->crcComponent(CrcLocation::vmeLm82);
      u->label(1);
      
      *u->data()=CrcLm82SlowControlsData();

      if(_printLevel>0) {
        std::cout << "DvrCrcSlw::record()  CrcLocationData<CrcLm82SlowControlsData> subrecord"
                  << std::endl;
        u->print(std::cout," ");
      }

      CrcLocationData<CrcLm82SlowControlsData>
        *v(inserter.insert< CrcLocationData<CrcLm82SlowControlsData> >());
      v->crateNumber(_crateNumber);
      v->slotBroadcast(true);
      v->crcComponent(CrcLocation::be);
      v->label(1);
      
      *v->data()=CrcLm82SlowControlsData();

      if(_printLevel>0) {
        std::cout << "DvrCrcSlw::record()  CrcLocationData<CrcLm82SlowControlsData> subrecord"
                  << std::endl;
        v->print(std::cout," ");
      }

      CrcLocationData<CrcLm82SlowControlsData>
        *w(inserter.insert< CrcLocationData<CrcLm82SlowControlsData> >());
      w->crateNumber(_crateNumber);
      w->slotBroadcast(true);
      w->crcComponent(CrcLocation::feBroadcast);
      w->label(1);
      
      *w->data()=CrcLm82SlowControlsData();

      if(_printLevel>0) {
        std::cout << "DvrCrcSlw::record()  CrcLocationData<CrcLm82SlowControlsData> subrecord"
                  << std::endl;
        w->print(std::cout," ");
      }

      _done=true;
      break;
    }

    default: {
      break;
    }
    };

    return true;
  }


protected:
  unsigned char _crateNumber;
  bool _done;
};

#endif
