#ifndef DvrDaq_HH
#define DvrDaq_HH

#include "DaqRunStart.hh"
#include "DaqConfigurationStart.hh"
#include "DaqSpillStart.hh"

#include "DaqCounter.hh"


class DvrDaq : public DaqCounter {

public:
  DvrDaq() {
  }

  virtual ~DvrDaq() {
  }

  void setRun(DaqRunStart &d) const {

    // Check run type
    switch (_runType) {

    case DaqRunStart::test: {
      switch (_runSubtype) {
      case 0: {
	d.maximumNumberOfConfigurationsInRun(2);
	d.maximumTimeOfRun(20);
	break;
      }
	
      default: {
	break;
      }
      };

      break;
    } // runType = test

    default: {
      break;
    }
    };
  }

  void setConfiguration(DaqConfigurationStart &d) const {

    // Check run type
    switch (_runType) {

    case DaqRunStart::test: {
      d.maximumNumberOfSpillsInConfiguration(3);
      d.maximumNumberOfEventsInConfiguration(0xffffffff);
      d.readoutMode(2);
      break;
    }
      
    default: {
      break;
    }
    };
  }

  void setSpill(DaqSpillStart &d) const {

    // Hardware limit
    d.maximumNumberOfEventsInSpill(511);

    // Check run type
    switch (_runType) {

    case DaqRunStart::test: {
      d.maximumNumberOfEventsInSpill(4);
      break;
    }
      
    default: {
      break;
    }
    };
  }
};

#endif
