#ifndef CommandClient_HH
#define CommandClient_HH

#include <sys/types.h>
#include <unistd.h>
#include <signal.h>

#include <cstdio>
#include <iostream>

#include "Command.hh"

class CommandClient {

public:
  CommandClient() {
    _sending=false;
  }

  void childPid(pid_t p) {
    std::cout << "Setting childPid = " << p << std::endl;
    _childPid=p;
  }

  void recv(const char* const s) {
    if(_sending) {
      _runActive=(s[0]!='I');
    } else {
      //std::cout << endl << "Enter command ";
      std::cout << '\r' << "Enter command ";
      if(s[0]=='I') std::cout << "  r(un), q(uit), k(ill): ";
      else          std::cout << " s(top), q(uit): ";
      std::cout << flush;
    }
  }

  const char* send() {
    cin >> r[0];

    // HOW TO DO A RECV HERE TO GET STATUS IN PARENT????


    if(r[0]=='q' || r[0]=='Q') {
      sprintf(r,"q\n");
      return r;
    }

    if(r[0]=='k' || r[0]=='K') {
      //if(c->command()==Command::run) {
      //  cout << "Cannot kill when running: stop first!!!" << endl;
      //} else {
      sprintf(r,"k\n");
      return r;
      //}
    }

    if(r[0]=='r' || r[0]=='R') {
      kill(_childPid,SIGUSR1);
      //if(c->command()==Command::run) {
      //  cout << "Already running!!!" << endl;
      //} else {
        sleep(1);
        cout << '\r' << "Enter run type (same as before = 0): " << flush;
        unsigned n(0);
        cin >> n;
	sprintf(r,"r%u\n",n);
	kill(_childPid,SIGUSR2);
	return r;
      //}
    }

    if(r[0]=='s' || r[0]=='S') {
      //if(c->command()==Command::stop) {
      //  cout << "Already stopped!!!" << endl;
      //} else {
      sprintf(r,"s\n");
      return r;
      //}
    }
    cout << "Unrecognised command" << endl;
  }


private:
  pid_t _childPid;
  bool _sending,_runActive;
  char r[16];
};

#endif
