#ifndef OnlCommand_HH
#define OnlCommand_HH

#include <iostream>

#include "RcdHeader.hh"

class OnlCommand {

public:
  OnlCommand() : _command(RcdHeader::startUp), _data(0) {
  }

  void reset() {
    _command=RcdHeader::startUp;
    _data=0;
  }

  RcdHeader::RecordType command() const {
    return _command;
  }

  void command(RcdHeader::RecordType c) {
    _command=c;
  }

  unsigned data() const {
    return _data;
  }

  void data(unsigned r) {
    _data = r;
  }

  void print(ostream &o) {
    o << "OnlCommand::print  Command type = " << _command
      << " = " << RcdHeader::recordTypeName(_command) << ", data = "
      << _data << std::endl;
  }
  
private:
  RcdHeader::RecordType _command;
  unsigned _data;
};

#endif
