#ifndef OnlCommandSocket_HH
#define OnlCommandSocket_HH

#include "DuplexSocket.hh"
#include "DioConsumer.hh"
#include "DioProducer.hh"
#include "OnlRunStatus.hh"
#include "OnlCommand.hh"


#ifdef DIO_SEND_OBJECTS

template<class Type> class OnlCommandSocket {

public:
  virtual int push(const T&) = 0;

  /*
  virtual int llup(DioProducer<Type> &p) {
    return push(p.pull());
  }
  */

private:
};

#endif
#ifndef DIO_SEND_OBJECTS

class OnlCommandSocket : 
  public DioProducer<OnlCommand>, public DioConsumer<OnlRunStatus::RunState> {

public:
  OnlCommandSocket(int port, bool singleSocket=true) 
    : _duplexSocket(port,singleSocket) {
    cout << "OnlCommandSocket::ctor()" << endl;
  }

  virtual DioControl push(DioTypeHolder<OnlRunStatus::RunState>& h) {
    /*
    DioControl c(h.control());
    //cerr << "Sending Control" << endl;
    _duplexSocket.send(&c,1);
    //cerr << "Sending Type" << endl;

    _duplexSocket.send(h.pointer(),1);
    */

    std::string cs("5\n");
    OnlRunStatus::RunState *s(h.pointer());
    if((*s)==OnlRunStatus::inactive) cs="0\n";
    if((*s)==OnlRunStatus::running) cs="1\n";
    if((*s)==OnlRunStatus::triggerable) cs="2\n";
    if((*s)==OnlRunStatus::readable) cs="3\n";
    if((*s)==OnlRunStatus::runningPaused) cs="5\n";
    if((*s)==OnlRunStatus::triggerablePaused) cs="6\n";
    if((*s)==OnlRunStatus::readablePaused)   cs="7\n";
    cout << "OnlCommandSocket::push() sending " << cs << endl;
    _duplexSocket.send(cs.c_str(),2);
    cout << "OnlCommandSocket::push() sent " << cs << endl;

    h.destroy();
    return h.control();
  }

  virtual DioTypeHolder<OnlCommand>& pull() {
    DioControl c;

    //    cerr << "Receiving Control" << endl;
    //_duplexSocket.recv(&c,1);
 
    //cerr << "Receiving Type" << endl;
    OnlCommand *t(new OnlCommand());
    t->data(999999);

    char x[8];
    cout << "OnlCommandSocket::pull() receiving" << endl;
    _duplexSocket.recv(x,4);
    cout << "OnlCommandSocket::pull() received " << x[0] << x[1] << endl;

    if(x[0]=='0' && x[1]=='1') {
      t->command(RcdHeader::startRun);
      cout << "OnlCommandSocket::pull() receiving data" << endl;
      _duplexSocket.recv(x,8);
      cout << "OnlCommandSocket::pull() received data " << x[0] << endl;
      if(x[0]!='9') t->data(1);
    }

    if(x[0]=='0' && x[1]=='2') {
      t->command(RcdHeader::startConfiguration);
      cout << "OnlCommandSocket::pull() receiving data" << endl;
      _duplexSocket.recv(x,8);
      cout << "OnlCommandSocket::pull() received data " << x[0] << endl;
      if(x[0]!='9') t->data(1);
    }

    if(x[0]=='0' && x[1]=='3') t->command(RcdHeader::startSpill);
    if(x[0]=='0' && x[1]=='5') t->command(RcdHeader::event);
    if(x[0]=='0' && x[1]=='6') t->command(RcdHeader::stopSpill);
    if(x[0]=='0' && x[1]=='7') t->command(RcdHeader::endSpill);
    if(x[0]=='0' && x[1]=='8') t->command(RcdHeader::pause);
    if(x[0]=='0' && x[1]=='9') t->command(RcdHeader::resume);
    if(x[0]=='1' && x[1]=='0') t->command(RcdHeader::stopConfiguration);
    if(x[0]=='1' && x[1]=='1') t->command(RcdHeader::endConfiguration);
    if(x[0]=='1' && x[1]=='2') t->command(RcdHeader::stopRun);
    if(x[0]=='1' && x[1]=='3') t->command(RcdHeader::endRun);
    if(x[0]=='1' && x[1]=='6') t->command(RcdHeader::shutdown);

    _holder=DioTypeHolder<OnlCommand>(t,c);
    return _holder;
  }

private:
  DuplexSocket _duplexSocket;
  DioTypeHolder<OnlCommand> _holder;
};

#endif
#endif
