#ifndef OnlCounter_HH
#define OnlCounter_HH

#include <iostream>
#include <fstream>

#include "RcdRecord.hh"
#include "DaqRunStart.hh"
#include "DaqConfigurationStart.hh"
#include "DaqEvent.hh"
#include "DaqConfigurationEnd.hh"
#include "DaqRunEnd.hh"
#include "RcdHeader.hh"
#include "SubInserter.hh"


class OnlCounter {

public:
  OnlCounter() {
  }

  virtual ~OnlCounter() {
  }

  void readout(RcdRecord &r, RcdHeader::RecordType t) {

    // Update header
    r.deleteData();
    r.updateRecordTime();
    r.recordType(t);

    SubInserter inserter(r);

    // Check record type
    switch (r.recordType()) {

    // Run start
    case RcdHeader::runStart: {
      _srs.reset();
      //_srs.runNumber(r.recordTime().seconds());
      inserter.insert(_srs);
      _srs.print(std::cout);

      r.print(std::cout);
      break;
    }


    // Configuration start
    case RcdHeader::configurationStart: {
      _scs.reset();
      _scs.maximumNumberOfSpillsInConfiguration(0);
      inserter.insert(_scs);

      // Config data !!!
      
      _sec.reset();

      r.print(std::cout);
      break;
    }



    // Spill start
    case RcdHeader::spillStart: {
      _sss.reset();
      _sss.maximumNumberOfEventsInSpill(0);
      inserter.insert(_sss);

      // Config data !!!
      
      _sec.reset();

      //r.print(std::cout);
      break;
    }


    // Event
    case RcdHeader::event: {
      inserter.insert(_sec);
      _sec.increment();
      //_sec.eventNumberInSpill(0);
      break;
    }


    // Configuration end
    case RcdHeader::configurationEnd:
    case RcdHeader::configurationStop: {
      _sce.configurationNumberInRun(_scs.configurationNumberInRun());
      _sce.actualNumberOfSpillsInConfiguration(0);
      _sce.actualNumberOfEventsInConfiguration(_sec.eventNumberInConfiguration());
      inserter.insert(_sce);
      _scs.increment();

      r.print(std::cout);
      break;
    }


    // Run end
    case RcdHeader::runEnd:
    case RcdHeader::runStop: {
      _sre.runNumber(_srs.runNumber());
      _sre.actualNumberOfConfigurationsInRun(_scs.configurationNumberInRun());
      _sre.actualNumberOfSpillsInRun(0);
      _sre.actualNumberOfEventsInRun(_sec.eventNumberInRun());
      inserter.insert(_sre);

      r.print(std::cout);
      break;
    }

    default: {
      break;
    }
    };
  }


private:
  DaqRunStart _srs;
  DaqConfigurationStart _scs;
  DaqSpillStart _sss;
  DaqEvent _sec;
  DaqSpillEnd _sse;
  DaqConfigurationEnd _sce;
  DaqRunEnd _sre;
};

#endif
