#ifndef OnlDemerger_HH
#define OnlDemerger_HH

#include "RcdTime.hh"
#include "RcdArena.hh"
#include "SubRecord.hh"
#include "DaqSubRecordId.hh"
#include "DioMultiProducer.hh"


class OnlDemerger : public DioMultiProducer<RcdArena> {

public:
  OnlDemerger(unsigned n) : DioMultiProducer<RcdArena>(n) {
  }

  virtual DioControl push(DioTypeHolder<RcdArena>& h) {
    _time.update();

    RcdArena *a(h.pointer());
    //std::cout << "OnlDemerger::push()  Incoming record" << std::endl;
    //a->print(std::cout);

    const RcdHeader *b(a);
    RcdArena _arena[_numberOfProducers];
    for(unsigned i(0);i<_numberOfProducers;i++) {
      _arena[i]=*b;
    }

    //std::cout << "OnlDemerger::push()  Copied header" << std::endl;
    //_arena[0].print(std::cout);

    SubRecord<RcdTime>::safePayloadAppend(a,&_time);
    //std::cout << "OnlDemerger::push()  Incoming record" << std::endl;
    //a->print(std::cout);

    const RcdSubHeader *s(0);
    for(s=a->firstSubHeader();s!=0;s=s->nextSubHeader()) {

      const unsigned type(s->subRecordType());
      //std::cout << "OnlDemerger::push()  SubHeader found, type " 
      //	<< type << std::endl;
      //s->print(std::cout);
      if(type!=0) {
	unsigned ic(_numberOfProducers);
	if(                type<0x1000) ic=0;
	if(0x1000<=type && type<0x2000) ic=1;
	if(0x2000<=type && type<0x3000) ic=2;
	if(0x3000<=type               ) ic=3;
	
	if(ic<_numberOfProducers) {
	  _arena[ic].appendSubHeader(s);
	  // std::cout << "OnlDemerger::push()  SubHeader appended to "
	  //    << ic << std::endl;
	  //_arena[ic].print(std::cout);
	  
	} else {
	  std::cerr << "OnlDemerger::push()  SubRecord discarded" << std::endl;
	}
      }
    }

    for(unsigned i(0);i<_numberOfProducers;i++) {
      DioTypeHolder<RcdArena> z(0,h.control());
      z.create(_arena+i);
      _connector[i].push(z);
    }

    h.destroy();
    return h.control();
  }


private:
  RcdTime _time;
};

#endif
