#ifndef OnlMerger_HH
#define OnlMerger_HH

#include "RcdTime.hh"
#include "RcdArena.hh"
#include "SubRecord.hh"
#include "DaqSubRecordId.hh"
#include "DioMultiProducer.hh"


class OnlMerger : public DioMultiConsumer<RcdArena> {

public:
  OnlMerger(unsigned n) : DioMultiConsumer<RcdArena>(n) {
  }

  virtual DioTypeHolder<RcdArena>& pull() {
    std::cout << "OnlMerger::pull()  Called" << std::endl;
    _time.update();

    DioTypeHolder<RcdArena> &h(_connector[0].pull());

    RcdArena *a(h.pointer());
    std::cout << "OnlMerger::pull()  Original record 0" << std::endl;
    a->print(std::cout);

    for(unsigned i(1);i<_numberOfConsumers;i++) {
      DioTypeHolder<RcdArena> &hi(_connector[i].pull());
      RcdArena *ai(hi.pointer());

      // CHECK HEADERS MATCH

      memcpy(a->lastSubHeader(),ai->firstSubHeader(),
	     ai->totalNumberOfBytes()-sizeof(RcdHeader));

      std::cout << "OnlMerger::pull()  SubHeaders for record " << i 
		<< " appended" << std::endl;
      a->print(std::cout);
      hi.destroy();
    }

    SubRecord<RcdTime>::safePayloadAppend(a,&_time);

    std::cout << "OnlMerger::pull()  Outgoing record" << std::endl;
    a->print(std::cout);

    return h;
  }


private:
  RcdTime _time;
};

#endif
