#ifndef OnlReader_HH
#define OnlReader_HH

#include <iostream>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>

#include <iostream>
#include <fstream>

#include "RcdTime.hh"
#include "RcdArena.hh"
#include "RcdReaderAsc.hh"
#include "RcdReaderBin.hh"
#include "SubRecord.hh"


class OnlReader : public DioProducer<RcdArena> {

public:
  enum OnlDataFormat {
    asc,
    bin
  };

  OnlReader(OnlDataFormat f=bin) : _format(f), _reader(0), _error(false) {
    if(_format==asc) _reader=new RcdReaderAsc;
    if(_format==bin) _reader=new RcdReaderBin;
  }

  virtual ~OnlReader() {
    delete _reader;
  }

  void open(const std::string file) {
    _reader->open(file);
  }

  DioTypeHolder<RcdArena>& pull() {
    _time.update();

    _holder.create();
    
    RcdRecord *record(_holder.pointer());
    if(_reader->read(record)) {
      //if(record->recordType()!=RcdHeader::endSpill) sleep(1);
      _holder.control(DioControl(DioControl::ok));
    } else {
      _reader->close();

      record->updateRecordTime();
      record->recordNumber(0);
      record->recordType(RcdHeader::shutdown);
      record->deleteSubHeaders();
      _holder.control(DioControl(DioControl::shutdown));
    }

    SubRecord<RcdTime>::safePayloadAppend(record,&_time);

    return _holder;
  }


protected:
  OnlDataFormat _format;
  RcdReader *_reader;
  DioTypeHolder<RcdArena> _holder;
  RcdTime _time;
  bool _error;
};

#endif
