#ifndef OnlRunType_HH
#define OnlRunType_HH

#include <vector>
#include <fstream>
#include <iostream>

#include "OnlConfigurationType.hh"


class OnlRunType {

public:
  OnlRunType() {
    reset(0);
  }

  virtual ~OnlRunType() {
  }
  
  const RcdArena& arena() const {
    return _arena;
  }
  
  RcdArena& arena() {
    return _arena;
  }
  
  /*
    RcdArena& configurationArena(unsigned c) {
    // Convert c to list location
    return _configurationTypes[c].arena();
    }
  */
  
  OnlConfigurationType& configurationType(unsigned c) {
    // Convert c to list location
    return _configurationTypes[c];
  }
  
  const OnlConfigurationType& configurationType(unsigned c) const {
    // Convert c to list location
    return _configurationTypes[c];
  }
  
  void reset(unsigned n) {
    _arena.recordType(RcdHeader::startRun);
    _arena.deleteSubHeaders();

    OnlSubRecord<OnlRunStatus> s;
    s.payload()->runNumber(n);
    _arena.appendSubHeader(&s);
    
    _configurationTypes.clear();
    _configurationTypeList.clear();
  }
  
  bool read(unsigned t) {
    char file[128];
    sprintf(file,"/usr/users/calice/daq/daq/typ/rtp%06.6u.asc",t);
    std::string s(file);
    cout << s << endl;
    
    bool reply(read(s,t));
    
    
    for(unsigned i(0);i<_configurationTypes.size();i++) {
      OnlConfigurationStatus
	*sc(OnlSubRecord<OnlConfigurationStatus>::
	    safePayload(_configurationTypes[i].arena().firstSubHeader()));
      if(sc!=0) {
	sc->maximumNumberOfConfigurationsInRun(_configurationTypes.size());
      }
    }
    
    return reply;
  }

  bool read(const std::string &filename, unsigned t) {
    ifstream i(filename.c_str(),ios::in);
    if(!i) return false;

    unsigned maxC(0),maxS(0),maxE(0);
    i >> maxC >> maxS >> maxE;
    cout << maxC << " " << maxS << " " << maxE << std::endl;

    OnlRunStatus
      *s(OnlSubRecord<OnlRunStatus>::safePayload(_arena.firstSubHeader()));
    if(s==0) return false;

    s->runType(t);
    s->maximumNumberOfConfigurationsInRun(maxC);
    s->maximumNumberOfSpillsInRun(maxS);
    s->maximumNumberOfEventsInRun(maxE);

    unsigned type(0),num(0);
    i >> type >> num;
    cout << type << " " << num << std::endl;

    while(!i.eof()) {
      append(type,num);
      i >> type >> num;
      cout << type << " " << num << std::endl;
    }

    if(_configurationTypeList.size()<maxC) {
      s->maximumNumberOfConfigurationsInRun(_configurationTypeList.size());
    }
    s->print(std::cout);

    for(unsigned j(0);j<_configurationTypes.size();j++) {
      OnlSubRecord<OnlRunStatus> *sp(
      OnlSubRecord<OnlRunStatus>::safeCast(_configurationTypes[j].arena().firstSubHeader()));
      if(sp!=0) {
        sp->payload()->maximumNumberOfConfigurationsInRun(_configurationTypes.size());
      }
    }

    return true;
  }

  void append(unsigned type, unsigned num=1) {
    bool readCT(true);
    for(unsigned j(0);j<_configurationTypeList.size();j++) {
      if(_configurationTypeList[j]==type) readCT=false;
    }
    
    if(readCT) {
      cout << "New Con type = " << type << endl;
      OnlSubRecord<OnlRunStatus> *sp(
				     OnlSubRecord<OnlRunStatus>::safeCast(_arena.firstSubHeader()));
      OnlConfigurationType t(*(sp->payload()));
      t.read(_configurationTypeList.size(),type);
      /*
	if(sp!=0) {
	sp->payload()->maximumNumberOfSpillsInRun(maxS);
	sp->payload()->maximumNumberOfEventsInRun(maxE);
	}
      */
      _configurationTypes.push_back(t);
    }
    
    for(unsigned j(0);j<num;j++) {
      _configurationTypeList.push_back(type);
    }
  }
  
  bool write(unsigned t) {
    char file[128];
    sprintf(file,"/usr/users/calice/daq/daq/typ/rtp%06.6u.asc",t);
    std::string s(file);
    cout << s << endl;
    return write(s);
  }

  bool write(const std::string &filename) {
    std::ofstream o(filename.c_str(),ios::out);
    if(!o) return false;

    OnlSubRecord<OnlRunStatus> *sp(
    OnlSubRecord<OnlRunStatus>::safeCast(_arena.firstSubHeader()));

    if(sp!=0) {
       o << sp->payload()->maximumNumberOfConfigurationsInRun()
         << sp->payload()->maximumNumberOfSpillsInRun()
         << sp->payload()->maximumNumberOfEventsInRun() << std::endl;
    }

    unsigned lastType(0xffffffff);
    unsigned num(1);
    for(unsigned j(0);j<_configurationTypeList.size();j++) {
	if(_configurationTypeList[j]==lastType) {
            num++;
        } else {
           if(j!=0) o << lastType << " " << num << std::endl;
           lastType=_configurationTypeList[j];
            num=1;
        }
      }        
      o << lastType << " " << num << std::endl;
  }

private:
  RcdArena _arena;
  std::vector<unsigned> _configurationTypeList;
  std::vector<OnlConfigurationType> _configurationTypes;
};

#endif
