#ifndef OnlSampler_HH
#define OnlSampler_HH

#include <iostream>
#include <fstream>

#include "RcdArena.hh"
#include "ShmObject.hh"
#include "DioConnector.hh"
#include "OnlSamplerStatus.hh"


class OnlSampler : public DioConnector<RcdArena> {

public:
  OnlSampler(key_t k) : _shm(k), _status(_shm.payload()) {
  }

  virtual DioControl push(DioTypeHolder<RcdArena> &h) {
    RcdRecord *r(h.pointer());

    if(r->recordType()==RcdHeader::startRun)
      _status->startRun();
    if(r->recordType()==RcdHeader::startConfiguration)
      _status->startConfiguration();
    if(r->recordType()==RcdHeader::startSpill)
      _status->startSpill();

    if(r->recordType()==RcdHeader::event) {
      if(newData()) {
	_status->event(true);
	_remove=true;
	h.destroy();
	return h.control();
      }
      _status->event(false);
    }

    _remove=false;
    return DioConnector<RcdArena>::push(h);
  }

  virtual void poc() {
    if(!_remove) DioConnector<RcdArena>::poc();
  }

private:
  bool _remove;

  ShmObject<OnlSamplerStatus> _shm;
  OnlSamplerStatus* const _status;
};

#endif
