#ifndef OnlSocketProducer_HH
#define OnlSocketProducer_HH

#include "RcdArena.hh"
#include "DuplexSocket.hh"
#include "DioProducer.hh"


#ifndef DIO_SEND_OBJECTS

class OnlSocketProducer : public DioProducer<RcdArena> {

public:
  OnlSocketProducer(int port, bool singleSocket=true) 
    : _duplexSocket(port,singleSocket) {
  }

  OnlSocketProducer(std::string host, int port, int tries = 0) 
    : _duplexSocket(host,port,tries) {
  }

  virtual DioTypeHolder<RcdArena>& pull() {
    DioControl c;
    //cerr << "Receiving Control" << endl;
    _duplexSocket.recv(&c,1);
    _holder.control(c);
 
    //cerr << "Receiving length" << endl;
    unsigned n(0);
    _duplexSocket.recv(&n,1);
 
    //cerr << "Receiving Type" << endl;
    _holder.create();
    RcdArena *p(_holder.pointer());
    //_duplexSocket.recv(t,1);
    _duplexSocket.recv((char*)p,n);

    if(p->totalNumberOfBytes()!=n) {
      std::cerr << "OnlSocketProducer::pull()  Number of bytes read = " << n
		<< " not equal to number expected in record = "
		<< p->totalNumberOfBytes() << std::endl;
    }

    return _holder;
  }

private:
  DuplexSocket _duplexSocket;
  DioTypeHolder<RcdArena> _holder;
};

#endif
#endif
