#ifndef OnlWriter_HH
#define OnlWriter_HH

#include <iostream>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>

#include <iostream>
#include <fstream>

#include "RcdArena.hh"
#include "RcdWriterAsc.hh"
#include "RcdWriterBin.hh"
#include "RcdWriterDmy.hh"
#include "SubRunStatus.hh"
#include "SubRecord.hh"


class OnlWriter : public DioConsumer<RcdArena> {

public:
  enum OnlDataFormat {
    asc,
    bin,
    dmy
  };

  OnlWriter(OnlDataFormat f=bin) : _format(f), _writer(0), _error(false) {
    if(_format==asc) _writer=new RcdWriterAsc;
    if(_format==bin) _writer=new RcdWriterBin;
    if(_format==dmy) _writer=new RcdWriterDmy;
  }

  virtual ~OnlWriter() {
    delete _writer;
  }

  virtual DioControl push(DioTypeHolder<RcdArena> &h) {
    RcdRecord *r(h.pointer());

    _error=false;
    if(r==0) {
      _error=true;
      std::cerr << "OnlWriter::push()  Null pointer to RcdArena" << std::endl;

    } else {
      if(r->recordType()!=RcdHeader::event) {
	std::cout << "OnlWriter::push()  Non-event record" << std::endl;
	r->print(std::cout);
      }

      switch (r->recordType()) {

      case RcdHeader::startRun: {
   	  SubRunStatus *s(0);
	  s=SubRecord<SubRunStatus>::safePayload(r->firstSubHeader());
	  if(s==0) {
	    _error=true;
	    std::cerr << "OnlWriter::push()  Null pointer to SubRunStatus"
		      << std::endl;
	  } else {
	    char file[128];
	    sprintf(file,"dat/run%06.6u",s->runNumber());
	    if(!(_writer->open(file))) {
	      _error=true;
	    } else {
	      _writer->write(r);
	    }
	  }
        }
	break;
	
      case RcdHeader::stopRun:
      case RcdHeader::endRun:
	_writer->write(r);
	_writer->close();
	break;
	
      case RcdHeader::startConfiguration:
      case RcdHeader::startSpill:
      case RcdHeader::event:
      case RcdHeader::pause:
      case RcdHeader::resume:
      case RcdHeader::stopSpill:
      case RcdHeader::endSpill:
      case RcdHeader::stopConfiguration:
      case RcdHeader::endConfiguration:
	_writer->write(r);
	break;
	
      default:
	break;
      };   
    }

    h.destroy();

    DioControl c(h.control());
    if(c.status()!=DioControl::ok) std::cout
      << "OnlWriter::push() status = " << c.status()
      << " = " << DioControl::statusName[c.status()] << std::endl;
    return c;
  }


protected:
  OnlDataFormat _format;
  RcdWriter *_writer;
  bool _error;
};

#endif
