#ifndef OnlWriterDmy_HH
#define OnlWriterDmy_HH

#include <iostream>

#include "OnlWriter.hh"
#include "OnlEventStatus.hh"
#include "OnlSubRecord.hh"


class OnlWriterDmy : public OnlWriter {

public:
  OnlWriterDmy() {
  }

  virtual ~OnlWriterDmy() {
  }

  bool open(unsigned n) {
    std::cout << "OnlWriterDmy::open() called for run number " 
	      << n << std::endl;
    return true;
  }

  bool write(const RcdRecord *r) {
    std::cout << "OnlWriterDmy::write() called for record at " 
	      << r << std::endl;

    if(r->recordType()!=RcdHeader::event) r->print(std::cout);
    else                                  r->RcdHeader::print(std::cout);

    const RcdSubHeader *h(r->firstSubHeader());
    const OnlRunStatus           *rs(OnlSubRecord<OnlRunStatus>::safePayload(h));
    if(rs!=0) rs->print(std::cout);
    const OnlConfigurationStatus *cs(OnlSubRecord<OnlConfigurationStatus>::safePayload(h));
    if(cs!=0) cs->print(std::cout);
    const OnlSpillStatus         *ss(OnlSubRecord<OnlSpillStatus>::safePayload(h));
    if(ss!=0) ss->print(std::cout);
    const OnlEventStatus         *es(OnlSubRecord<OnlEventStatus>::safePayload(h));
    if(es!=0) es->print(std::cout);

    return true;
  }

  bool close() {
    std::cout << "OnlWriterDmy::close() called" << std::endl;
    return true;
  }

private:
};

#endif
