#ifndef ReaderServer_HH
#define ReaderServer_HH

#include "BufferStatus.hh"
#include "RecordBuffer.hh"
#include "ShmSingleton.hh"

class ReaderServer {


public:
  ReaderServer(bool dummy=false) : _shmR(), _recordBuffer(_shmR.payload()) {
    if(_recordBuffer!=0) {
      if(!_recordBuffer->setProducerPid(dummy)) _recordBuffer=0;
    }
    if(_recordBuffer==0) cerr << "recordBuffer zero" << flush << endl;
  }

  ~ReaderServer() {
    if(_recordBuffer==0) return;
    if(!_recordBuffer->dummyProducerPid()) _recordBuffer->zeroProducerPid();
  }

  void recv(Record *r) {
    if(_recordBuffer==0) return;
    if(r->recordType()!=RecordHeader::event) r->print(cout);
    Record *n(_recordBuffer->getNewEvent());

    // LOTS TO DO HERE 

    *n=*r; /// THIS DOESNT COPY SUBRECORDS!!!
    if(r->recordType()==RecordHeader::event) {
      SubRecord *s((SubRecord*)n->firstSubRecord());
      s->subRecordType(SubRecord::ecal);
      unsigned *d(s->firstWord());
      for(unsigned k(0);k<128;k++) d[k]=k;
      s->numberOfWords(128);
      n->addLastSubRecord(s); 
    }

    if(n->recordType()!=RecordHeader::event) n->print(cout);
  }

  bool send() const {
    if(_recordBuffer==0) return true;
    _recordBuffer->releaseNewEvent();
    return false;
  }

  void setDummy() {
    _recordBuffer->zeroProducerPid();
    _recordBuffer->setProducerPid(true);
  }


private:
  ShmSingleton<RecordBuffer> _shmR;
  RecordBuffer* _recordBuffer;
};

#endif
