#ifndef WriterClient_HH
#define WriterClient_HH

#include <iostream>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>

#include <iostream>
#include <fstream>

#include "Record.hh"

class WriterClient {

public:
  WriterClient() : pout(0), _error(false) {
  }

  ~WriterClient() {
    delete pout;
  }

  void recv(Record* r) {
    _error=false;
    if(r==0) {
      _error=true;
    } else {
      if(r->recordType()!=RecordHeader::event) r->print(cout);

      switch (r->recordType()) {
      case RecordHeader::startOfRun:
	if(pout!=0) {
	  delete pout;
	  cerr << " Output file pointer non-zero at startOfRun" << endl;
	}
	
	char file[128];
	sprintf(file,"dat/run%06.6u.dat",r->runNumber());
	pout=new ofstream(file,ios::out);
	
	if(pout==0 || !(*pout)) {
	  cerr << " Error opening file " << file << endl;
	  _error=true;
	  
	} else {
	  cout << " New run: number " << r->runNumber() 
	       << " writing to file " << file << endl;
	  r->write(*pout);
	}
	break;
	
      case RecordHeader::endOfRun:
	if(pout!=0) {
	  r->write(*pout);
	  delete pout;
	  pout=0;
	} else {
	  cerr << " Output file pointer zero at endOfRun" << endl;
	}
	break;
	
      case RecordHeader::startOfConfiguration:
      case RecordHeader::startOfSpill:
      case RecordHeader::event:
      case RecordHeader::stopRun:
      case RecordHeader::endOfSpill:
      case RecordHeader::endOfConfiguration:
	if(pout!=0) {
	  r->write(*pout);
	} else {
	  cerr << " Output file pointer zero at general record" << endl;
	}
	break;
	
      default:
	break;
      };   
    }
  }

  bool send() {
    return _error;
  }

private:
  ofstream *pout;
  bool _error;
};

#endif
