#include <iostream>

#include "UtlArguments.hh"
#include "RcdArena.hh"
#include "SubInserter.hh"

#include "BmlCaen767Readout.hh"

using namespace std;


int main(int argc, const char **argv) {

  UtlArguments argh(argc,argv);
  const bool memTest(argh.option('m',false,"Do memory test"));
  const unsigned nEvents(argh.optionArgument('e',10,"Number of events"));
  if(argh.help()) return 0;

  BmlCaen767Readout asr(0,0xac,0xcae0,0xcae1);
  asr.printLevel(99);

 // Define record memory
  RcdArena arenas[16];
  RcdArena &arena(arenas[0]);

  arena.initialise(RcdHeader::startUp);
  asr.record(arena);
  //     sleep(10);
    
  arena.initialise(RcdHeader::runStart);
  /*
  SubInserter inserter(arena);
  BmlLocationData<BmlCaen767OpcodeData>
    *d(inserter.insert< BmlLocationData<BmlCaen767OpcodeData> >(true));
  d->baseAddress(0xffff);
  d->label(1);
  d->print(std::cout," ORIG ") << std::endl;
  */

  asr.record(arena);
  //  sleep(10);

  for(unsigned i(0);i<4;i++) {
    arena.initialise(RcdHeader::configurationStart);

    SubInserter inserter(arena);
    BmlCaen767ReadoutConfigurationData
      *rc(inserter.insert<BmlCaen767ReadoutConfigurationData>(true));

    rc->bltReadout(false);
    rc->arrayReadout(false);
    rc->softTrigger(!memTest);
    //rc->softTrigger(true);
    rc->print(std::cout," ORIG ") << std::endl;
    
    BmlLocationData<BmlCaen767ConfigurationData>
      *d(inserter.insert< BmlLocationData<BmlCaen767ConfigurationData> >(true));
    d->baseAddress(0xffff);
    d->label(1);
    //d->data()->controlRegister(0,4); // Send data to end-of-block
    d->data()->controlRegister(0,0);

    const BmlCaen767OpcodeData xxx;
    d->data()->controlRegister(1,xxx.controlRegister2());
    d->data()->memoryTest(memTest);

    d->print(std::cout," ORIG ") << std::endl;

    asr.record(arena);
    

    arena.initialise(RcdHeader::acquisitionStart);

    if(memTest) {
      BmlLocationData<BmlCaen767TestData>
	*td(inserter.insert< BmlLocationData<BmlCaen767TestData> >(true));
      td->baseAddress(0xffff);
      td->label(1);
      //td->data()->setPattern(BmlCaen767TestData::count);
      //td->data()->setPattern(BmlCaen767TestData::empty);
      td->data()->setPattern(BmlCaen767TestData::event,10*i);
      td->data()->numberOfRepeats(nEvents);
      td->print(std::cout," ORIG ") << std::endl;
      assert(inserter.extend(td->data()->numberOfWords()*4));
    }

    asr.record(arena);

    for(unsigned j(0);j<nEvents;j++) {
      std::cout << "Starting trigger " << j << std::endl; 
      arena.initialise(RcdHeader::trigger);
      asr.record(arena);
    }

    for(unsigned j(0);j<nEvents;j++) {
      std::cout << "Starting event " << j << std::endl; 
      arena.initialise(RcdHeader::event);
      asr.record(arena);
    }

    arena.initialise(RcdHeader::acquisitionEnd);
    asr.record(arena);

    arena.initialise(RcdHeader::configurationEnd);
    asr.record(arena);
  }

  arena.initialise(RcdHeader::runEnd);
  asr.record(arena);
  return 0;
}
