// g++ -Wall -I ../../daq/dual/inc/utl -I ../../daq/dual/inc/daq -I ../../daq/dual/inc/rcd -I ../../daq/dual/inc/emc -I ../../daq/dual/inc/sub -I ../inc/msg -I ../inc/usb -I ../inc/hod -I ../inc/cec -I ../inc/rcd noise.cc -o noise.exe

#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>

#include <iostream>
#include <sstream>
#include <vector>
#include <cstdio>

#include "DaqBusAdapter.hh"

#include "VMEAddressTable.hh"
#include "VMEAddressTableASCIIReader.hh"
#include "HardwareAccessException.hh"

#include "UtlArguments.hh"
#include "CrcVmeDevice.hh"
#include "CrcVmeRunData.hh"


using std::cin;
using std::exception;
using namespace std;

#define CERCVMEADDRESSTABLE "online/hal/CrcVmeAddress.hal"
#define SEQUENCE_SETTINGS "Sequences.dat"


bool continueJob=true;

void signalHandler(int signal) {
  std::cout << "Process " << getpid() << " received signal "
	    << signal << std::endl;
  continueJob=false;
}

int main(int argc, const char **argv) {
  try{

  UtlArguments argh(argc,argv);
  //argh.print(cout);

  const bool doCheck(argh.option('c',"Run data check"));
  const bool doHistograms(argh.option('s',"Display histograms"));
  const bool doGraphics(argh.option('g',"Display graphics"));
  const bool useIntTrigger(argh.option('i',"Internal trigger selection"));

  const unsigned printLevel(argh.optionArgument('p',5,"Print level"));
  const unsigned feMask(argh.optionArgument('f',0xff,"FE mask"));
  const unsigned nEvents(argh.optionArgument('n',10,"Number of events between updates"));

  std::string logFile(argh.optionArgument('l',"log/msg.log","RS232 message log file"));

  if(argh.help()) return 0;

  if(doCheck) cout << "Data check selected" << endl;
  else           cout << "Data check not selected" << endl;
  if(doHistograms) cout << "Histograms display selected" << endl;
  else           cout << "Histograms display not selected" << endl;
  if(doGraphics) cout << "Graphics display selected" << endl;
  else           cout << "Graphics display not selected" << endl;
  if(useIntTrigger) cout << "Internal trigger selected" << endl;
  else              cout << "External trigger selected" << endl;

  cout << "Print level set to " << printLevel << endl;
  cout << "FE mask set to " << printHex((unsigned char)feMask) << endl;
  cout << "Number of events set to " << nEvents << endl;

  DaqBusAdapter busAdapter(0);
  VMEAddressTableASCIIReader addressTableReader( CERCVMEADDRESSTABLE );
  VMEAddressTable addressTable( "Test address table", addressTableReader );

  unsigned array[1024];
  CrcVmeRunData *d((CrcVmeRunData*)array);

  CrcVmeDevice *dev[22];
  for(unsigned i(9);i<10;i+=4) {
    dev[i]=new CrcVmeDevice(addressTable,busAdapter,i);
    if(dev[i]->alive()) {
      dev[i]->initialiseEprom(18);// CARE!

      //std::string s("CRC SER010");
      //assert(dev[i]->writeEpromMessage(s));

      assert(dev[i]->readVmeRunData(*d));
      d->print(std::cout);
    }
  }

} catch ( HardwareAccessException& e ) {
  cout << "*** Exception occurred : " << endl;
  cout << e.what() << " I Made This" << endl;
    
} catch ( exception e ) {
  cout << "*** Unknown exception occurred" << endl;
}


}
