#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>

#include <cstdio>
#include <vector>
#include <string>
#include <iomanip>
#include <iostream>

#include "VMEAddressTable.hh"
#include "VMEAddressTableASCIIReader.hh"
#include "SBS620x86LinuxBusAdapter.hh"
//#include "VMEDummyBusAdapter.hh"
#include "HardwareAccessException.hh"

#include "CrcSerialCommandFeAddress.hh"
#include "CrcSerialCommandWord.hh"
#include "CrcVmeDevice.hh"
#include "CrcFeConfigurationData.hh"
#include "CrcLm82StartupData.hh"
#include "CrcLm82SetupData.hh"
#include "CrcLm82SlowControlsData.hh"
//#include "SlwCercReadout.hh"
#include "RcdArena.hh"
#include "UtlTime.hh"
#include "UtlArguments.hh"
#include "RcdWriterAsc.hh"

using std::cin;
using std::exception;
using namespace std;

#define CERCVMEADDRESSTABLE "CercAddressMap.dat"
#define SEQUENCE_SETTINGS "Sequences.dat"

bool continueJob=true;

void signalHandler(int signal) {
  std::cout << "Process " << getpid() << " received signal "
            << signal << std::endl;
  continueJob=false;
}


int main(int argc, const char **argv) {
  UtlArguments argh(argc,argv);


  unsigned numberOfCrcs(1);
  unsigned *addressOfCrc(new unsigned[numberOfCrcs]);
  addressOfCrc[0]=7;

  try {
    // if you want to play with real hardware you need a real busAdapter:
    // change the comments below:
    // MXI2x86LinuxBusAdapter busAdapter(0);
    SBS620x86LinuxBusAdapter busAdapter(0);
    // VMEDummyBusAdapter busAdapter;

    VMEAddressTableASCIIReader addressTableReader( CERCVMEADDRESSTABLE );
    VMEAddressTable addressTable( "Test address table", addressTableReader );

    if(addressTable.exists("SerialRead")) cout << "exists" << endl;
    else                                  cout << "non-exists" << endl;

    cout << "Number of CERCs = " << numberOfCrcs << endl;
    CrcVmeDevice *CrcVMECard[20];
    for(unsigned i(0);i<numberOfCrcs;i++) {
      cout << "Address of CERC[" << i << "] = " 
	   << hex << addressOfCrc[i] << dec << endl;
      CrcVMECard[i]=new CrcVmeDevice(addressTable,busAdapter,addressOfCrc[i]);
    }

    //CrcVmeDevice CrcVMECard(addressTable, busAdapter, CERCVME_BASEADDRESS);
    
    //PersistentCommandSequencer sequencer( SEQUENCE_SETTINGS, addressTable );

    string item, name;
    unsigned long nCard;
    vector<string> names;

    nCard=0;

    unsigned t;
    std::string w;

    cout << "FE: ";
    //    if(argh.isArgument(0)) {
      t=argh.argument(0,0);
      cout << t << endl;
      //} else {
      //  cin >> t;
      // }

      assert(CrcVMECard[nCard]->feSoftReset());
      cout << "Soft reset OK" << endl;
      cout << endl;

      CrcLm82StartupData d;
      CrcVMECard[nCard]->readLm82Startup((CrcLocation::CrcComponent)t,d);
      d.print(cout);
      cout << endl;

      CrcLm82SetupData wLs,rLs;
      wLs.configuration(0x28);
      wLs.criticalLimit(99);
      wLs.localLimit(51);
      wLs.remoteLimit(50);
      wLs.print(cout);
      CrcVMECard[nCard]->writeLm82Setup((CrcLocation::CrcComponent)t,wLs);
      cout << endl;

      for(unsigned i(0);i<4;i++) {
	CrcVMECard[nCard]->readLm82Setup((CrcLocation::CrcComponent)t,rLs);
	if(rLs!=wLs) {
	  cout << "ERROR on FeLm82Setup readback" << endl;
	  rLs.print(cout);
	  cout << endl;
	  i=999;
	}
      }

      CrcLm82SlowControlsData f;
      CrcVMECard[nCard]->readLm82SlowControls((CrcLocation::CrcComponent)t,f);
      f.print(cout);
      cout << endl;

      CrcFeRunData fer;
      CrcVMECard[nCard]->readFeRunData((CrcLocation::CrcComponent)t,fer);
      fer.print(cout);
      cout << endl;

      CrcFeConfigurationData wFec;
      wFec.frameSyncDelay(12345);
      wFec.qdrDataDelay(3);
      CrcVMECard[nCard]->writeFeConfigurationData((CrcLocation::CrcComponent)t,wFec);

      CrcSerialCommandFeAddress a((CrcSerialHeader::Target)(t+1));
      a.address(32);
      assert(CrcVMECard[nCard]->serialWrite(&a));

      CrcSerialCommandWord s((CrcSerialHeader::Target)(t+1),
			     CrcSerialHeader::feDataOut);

      while(true) {
	cout << "Starting ramp" << endl;
	for(unsigned d(0);d<0x10000;d+=1) {
	  //wFec.dacData(0,d);
	  //wFec.dacData(1,d);
	  //wFec.print(cout);
	  //cout << endl;
	  //CrcVMECard[nCard]->writeFeConfigurationData((CrcLocation::CrcComponent)t,wFec);

	  s.data(d);
	  assert(CrcVMECard[nCard]->serialWrite(&s));
	  //if(d==0) d=1024*16;
	}
      }

      /*
      CrcFeConfigurationData rFec;
      for(unsigned i(0);i<4;i++) {
      CrcVMECard[nCard]->readFeConfigurationData((CrcLocation::CrcComponent)t,rFec);
	if(rFec!=wFec) {
	  cout << "ERROR on FeConfigurationData readback" << endl;
	  rFec.print(cout);
	  cout << endl;
	  i=999;
	}
      }

      unsigned wArray[513],rArray[513];
      CrcFeFakeEventData *wFek((CrcFeFakeEventData*)wArray),*rFek((CrcFeFakeEventData*)rArray);
      wFek->numberOfWords(256);
      wFek->enable(true);
      for(unsigned i(0);i<wFek->numberOfWords();i++) {
	if((i%2)==0) wArray[i+1]=(~((0xaa00+i)<<16))&0xffff0000|(0xaa00+i);
	else         wArray[i+1]=(~((0x5500+i)<<16))&0xffff0000|(0x5500+i);
      }
      wFek->print(cout);
      CrcVMECard[nCard]->writeFeFakeEventData((CrcLocation::CrcComponent)t,*wFek);
      cout << endl;

      for(unsigned i(0);i<4;i++) {
	CrcVMECard[nCard]->readFeFakeEventData((CrcLocation::CrcComponent)t,*rFek);
	if((*rFek)!=(*wFek)) {
	  cout << "ERROR on FeFakeEventData readback" << endl;
	  rFek->print(cout);
	  cout << endl;
	  i=999;
	}
      }

      CrcFeEventData fee;
      CrcVMECard[nCard]->readFeEventData((CrcLocation::CrcComponent)t,fee);
      fee.print(cout);
      cout << endl;

      const unsigned nTrg(1000);
      cout << "Sending " << nTrg << " FE soft triggers" << endl;

      for(unsigned j(1);j<=nTrg;j++) {
	CrcVMECard[nCard]->feSoftTrigger();

	for(unsigned i(0);i<4;i++) {
	  CrcVMECard[nCard]->readFeEventData((CrcLocation::CrcComponent)t,fee);
	  if(fee.triggerCounter()!=j) {
	    cout << "ERROR on FeEventData readback" << endl;
	    fee.print(cout);
	    cout << endl;
	    i=999;
	  }
	}
      }

      CrcVMECard[nCard]->readFeEventData((CrcLocation::CrcComponent)t,fee);
      fee.print(cout);
      cout << endl;

      unsigned p[1024*128];
      unsigned n(CrcVMECard[nCard]->vlinkRead(p));
      cout << "Number of Vlink words = " << n << endl;

      for(unsigned i(0);i<n;i++) {
	cout << " Vlink word " << setw(4) << i << " = "
	     << printHex(p[i]) << endl;
      }
      */

  } catch ( HardwareAccessException& e ) {
    cout << "*** Exception occurred : " << endl;
    cout << e.what() << "I Made This" << endl;

  } catch ( exception e ) {
    cout << "*** Unknown exception occurred" << endl;
  }
  return 0;
}
