#include <signal.h>
#include <sys/types.h>
#include <unistd.h>

#include <iostream>

#include "ChkCount.hh"
#include "ShmObject.hh"

using namespace std;

bool continueJob=true;

void signalHandler(int signal) {
  std::cerr << "Process " << getpid() << " received signal "
            << signal << std::endl;
  continueJob=false;
}

int main(int argc, char *argv[]) {
  signal(SIGINT,signalHandler);

  const ShmObject<ChkCount> shmU(123456786);
  const ChkCount* const p(shmU.payload());
  if(p==0) return 0;

  unsigned nOld(0),nSleep(5);
  double hz(1.0/nSleep);

  while(continueJob) {
    p->print(cout);
    cout << "Trigger rate = " << setw(4)
	 << hz*(p->count(RcdHeader::event)-nOld) << " Hz" << endl;
    nOld=p->count(RcdHeader::event);
    sleep(nSleep);
  }
  
  return 0;
}
