// g++ -I../../../dual/inc/rcd -I../../inc/sem -I../../inc/skt -I../../inc/dio -I../../inc/onl driverReader.cc -o driverReader -lpthread

#include <unistd.h>
#include <cstdio>
#include <pthread.h>

#include <iostream>

#include "DioSocketConsumer.hh"
#include "DioThread.hh"
#include "OnlReader.hh"
#include "OnlSocketConsumer.hh"
#include "OnlDemerger.hh"

using namespace std;

int main() {
  OnlReader r(OnlReader::bin); // TEMP!!!
  r.open("driverFile"); // TEMP!!!
  OnlDemerger m(4);
  /*
  DioSocketConsumer<RcdArena> c0(12330);
  DioSocketConsumer<RcdArena> c1(12331);
  DioSocketConsumer<RcdArena> c2(12332);
  DioSocketConsumer<RcdArena> c3(12333);
  */
  OnlSocketConsumer c0(12330);
  OnlSocketConsumer c1(12331);
  OnlSocketConsumer c2(12332);
  OnlSocketConsumer c3(12333);

  DioThread<RcdArena> t0(r,m);
  t0.create();
  DioThread<RcdArena> t1(m.producer(0),c0);
  t1.create();
  DioThread<RcdArena> t2(m.producer(1),c1);
  t2.create();
  DioThread<RcdArena> t3(m.producer(2),c2);
  t3.create();
  DioThread<RcdArena> t4(m.producer(3),c3);
  t4.create();

  t0.join();
  t1.join();
  t2.join();
  t3.join();
  t4.join();

  return 0;
}
