/***********************************************************************
 localStatus
 ***********************************************************************/

#include <ctime>
#include <iostream>

#include "RecordBuffer.hh"
#include "ShmSingleton.hh"

using namespace std;

class Doit {

public:
  Doit() : _shmR(), _bufferStatus(_shmR.payload()) {
  }

  const BufferStatus* const getBufferStatus() const {
    return _bufferStatus;
  }

private:
  ShmSingleton<RecordBuffer> _shmR;
  const BufferStatus* const _bufferStatus;
};


main(int argc, char *argv[]) {
  time_t t;
  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Starting" << endl;

  Doit doit;
  const BufferStatus* const b(doit.getBufferStatus());

  if(b==0) {
    cerr << argv[0] << " " << ctime(&(t=time(0)));
    cerr << " BufferStatus pointer is null" << endl;

  } else {
    while(!b->shutDown()) {
      cout << argv[0] << " " << ctime(&(t=time(0)));
      b->print(cout);
      sleep(1);
    }

    cout << argv[0] << " " << ctime(&(t=time(0)));
    cout << " Shutdown command seen" << endl;
  }

  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Exiting" << endl;
  return 0;
}
