// g++ -I../../../dual/inc/rcd -I../../../dual/inc/sub -I../../inc/sem -I../../inc/skt -I../../inc/shm -I../../inc/dio -I../../inc/onl partialWriter.cc -o partialWriter -lpthread

// With ROOT
// g++ `$ROOTSYS/bin/root-config --cflags` -I../../../dual/inc/rcd -I../../../dual/inc/sub -I../../inc/sem -I../../inc/skt -I../../inc/shm -I../../inc/dio -I../../inc/onl partialWriter.cc -o partialWriter `$ROOTSYS/bin/root-config --new --libs`

#include <unistd.h>
#include <cstdio>
#include <pthread.h>

#include <iostream>

#include "DioSocketProducer.hh"
#include "DioMultiConsumer.hh"
#include "DioMultiProducer.hh"
#include "DioThread.hh"
#include "OnlReader.hh" // TEMP!!!
#include "OnlSocketProducer.hh"
#include "OnlMerger.hh"
#include "OnlWriter.hh"
#include "OnlSampler.hh"
#include "OnlMonitor.hh"

using namespace std;

int main() {
  /*
  DioSocketProducer<RcdArena> p0("localhost",12330,1000);
  DioSocketProducer<RcdArena> p1("localhost",12331,1000);
  DioSocketProducer<RcdArena> p2("localhost",12332,1000);
  DioSocketProducer<RcdArena> p3("localhost",12333,1000);
  */
  OnlSocketProducer p0("localhost",12330,1000);
  OnlSocketProducer p1("localhost",12331,1000);
  OnlSocketProducer p2("localhost",12332,1000);
  OnlSocketProducer p3("localhost",12333,1000);
  //DioMultiConsumer<RcdArena> m(4);
  OnlMerger m(4);
  /*
  OnlReader m(OnlReader::bin); // TEMP!!!
  m.open("dat/driverFile"); // TEMP!!!
  */
  DioMultiProducer<RcdArena> c(2);
  OnlWriter w(OnlWriter::bin);
  OnlSampler s(344567);
  OnlMonitor h;

  DioThread<RcdArena> t0(p0,m.consumer(0));
  t0.create();
  DioThread<RcdArena> t1(p1,m.consumer(1));
  t1.create();
  DioThread<RcdArena> t2(p2,m.consumer(2));
  t2.create();
  DioThread<RcdArena> t3(p3,m.consumer(3));
  t3.create();
  DioThread<RcdArena> t4(m,c);
  t4.create();
  /*
  */
  DioThread<RcdArena> t5(c.producer(0),w);
  t5.create();
  DioThread<RcdArena> t6(c.producer(1),s);
  t6.create();
  DioThread<RcdArena> t7(s,h);
  t7.create();

  t0.join();
  t1.join();
  t2.join();
  t3.join();
  /*
  */
  t4.join();
  t5.join();
  t6.join();
  t7.join();

  return 0;
}
