/***********************************************************************
 readerDummy
 ***********************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>

#include <iostream>
#include <fstream>

#include "Record.hh"
#include "ReaderServer.hh"

using namespace std;

main(int argc, char *argv[]) {
  time_t t;
  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Starting" << endl;

  ReaderServer server;
  Record r;

  r.recordType(RecordHeader::startUp);
  r.recordTime(time(0));
  r.print(cout);
  server.recv(&r);
  server.send();

  unsigned rn(0);
  r.recordType(RecordHeader::startOfRun);
  r.recordTime(time(0));
  r.recordNumber(rn++);
  r.runNumber(999999);
  r.runType(987654321);
  r.numberOfConfigurations(1);
  r.print(cout);
  server.recv(&r);
  server.send();
  
  r.recordType(RecordHeader::startOfConfiguration);
  r.recordTime(time(0));
  r.recordNumber(rn++);
  r.configurationNumber(1);
  r.configurationType(2);
  r.numberOfEventsInConfiguration(0xffffffff);
  r.print(cout);
  server.recv(&r);
  server.send();
  
  r.recordType(RecordHeader::event);
  for(unsigned i(0);i<100;i++) {
    r.recordTime(time(0));
    r.recordNumber(rn++);
    r.eventNumber(i);
    r.print(cout);
    server.recv(&r);
    server.send();
  }

  server.setDummy();

  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Exiting" << endl;
  return 0;
}
