/***********************************************************************
 reader - reads out VME into shared memory buffer
***********************************************************************/

#include <ctime>
#include <cstdlib>

#include <iostream>
#include <fstream>

#include "RunRecord.hh"
#include "RunType.hh"
#include "ConfigurationRecord.hh"
#include "EventRecord.hh"
#include "Control.hh"
#include "RecordBuffer.hh"
#include "VmeCrate.hh"
#include "ShmSingleton.hh"

using namespace std;

unsigned readRunNumber() {
  ifstream fin("runs/runnumber.dat",ios::in);
  if(!fin) return 0;
  unsigned n(0);
  fin >> n;
  return n;
}

bool writeRunNumber(unsigned n) {
  ofstream fout("runs/runnumber.dat",ios::out);
  if(!fout) return false;
  fout << n << endl;
  return true;
}


main(int argc, char *argv[]) {
  ShmSingleton<Control> shmC;
  Control* c(shmC.payload());

  if(c==0) {
    cerr << argv[0] << ": Null pointer for ShmSingleton<Control>" << endl;
    return 1;
  }

  if(c->command() == Control::run) {
    cerr << argv[0] << ": Run in progress" << endl;
    return 1;
  }

  ShmSingleton<RecordBuffer> shmE;
  RecordBuffer* e(shmE.payload());

  if(e==0) {
    cerr << argv[0] << ": Null pointer for ShmSingleton<RecordBuffer>" << endl;
    return 1;
  }

  if(!e->producerPid(getpid())) {
    cerr << argv[0] << ": Producer already registered with ShmSingleton<RecordBuffer>" << endl;
    return 1;
  }
  
  ShmSingleton<VmeCrate> shmV;
  VmeCrate *v(shmV.payload());

  if(v==0) {
    cerr << argv[0] << ": null pointer for ShmSingleton<VmeCrate>" << endl;
    return 1;
  }

  cout << argv[0] << ": all shared memory attached" << endl;


  unsigned printLevel(0);
  if(argc>1) sscanf(argv[1],"%u",&printLevel);
  cout << argv[0] << ": print level set to " << printLevel << endl;


  unsigned runNumber(readRunNumber());
  cout << argv[0] << ": previous run number " << runNumber << endl;


  c->readerStatus(Control::stopped);
  v->reset();

  while(c->command() != Control::kill) { // Loop over runs
    if(c->command() == Control::run) {
      c->readerStatus(Control::changing);
      bool runAbort(false);

      RunType rt(c->runType());
      
//      while(e->getNewEvent()==0);
      RunRecord *p((RunRecord*)e->getNewEvent());
      
      runNumber++;
      
      p->recordType(RecordBuffer::startOfRun);
      p->recordTime();
      p->runType(rt.runType());
      p->runNumber(runNumber);
      p->numberOfConfigurations(rt.numberOfConfigurations());
      p->numberOfShortWords();
      
      e->releaseNewEvent();
      
      if(!writeRunNumber(runNumber)) {
	cerr << argv[0] << ": run number write failed" << endl;
      } else {
	cout << argv[0] << ": run number ";
	system("cat runs/runnumber.dat");
      }
      
      unsigned nTotal(0);
      c->readerStatus(Control::running);
      
      
      for(unsigned d(0);d<rt.numberOfConfigurations() && 
	    c->command()==Control::run;d++) {
	
	v->putConfiguration(rt.configuration(d));
	
	while(e->getNewEvent()==0);
	ConfigurationRecord *ps((ConfigurationRecord*)e->getNewEvent());
	
	ps->recordType(RecordBuffer::startOfConfiguration);
	ps->recordTime();
	ps->configurationNumber(d);
	ps->numberOfEvents(nTotal);
	ps->numberOfConfigurationEvents(rt.numberOfEvents(d));
	ps->numberOfShortWords();
	v->getConfiguration(ps->configuration());
	
	/*
	if(*(ps->configuration())!=rt.configuration(d)) {
	  cerr << argv[0] << ": configuration corruption" << endl;
	}
	*/

	e->releaseNewEvent();

	unsigned nConfig(0);
	
	for(unsigned n(0);n<rt.numberOfEvents(d) && 
	      c->command()==Control::run;n++) {

	  //	  if(nTotal>29835) printLevel=4;

	  
	  v->trigger(false);
	  v->readyForReadout(false);
	  
	  if(printLevel>=4) cout << argv[0] << ": here 1 " << endl;

	  if(!v->externalTrigger()) v->trigger(true);
	  while(!v->readyForReadout());
	  
	  if(printLevel>=4) cout << argv[0] << ": here 2 " << endl;

	  while(e->getNewEvent()==0);
	  EventRecord *p(e->getNewEvent()); // FAIL?

	  if(printLevel>=4) cout << argv[0] << ": here 3 " << endl;

	  if(printLevel>=4 && p==0) cout << argv[0] << ": event number " 
					 << nTotal << " null EventRecord ptr"
					 << endl;
	  
	  if((printLevel==0 && (n%10000)==0) ||
	     (printLevel==1 && (n%1000 )==0) ||
	     (printLevel==2 && (n%100  )==0) ||
	     (printLevel==3 && (n%10   )==0) ||
	     (printLevel>=4)) cout << argv[0] << ": event number " 
				   << nTotal << endl; 	  	  
	  p->recordType(RecordBuffer::event);
	  p->recordTime();
	  p->eventNumber(n);
	  p->numberOfShortWords();
	  if(printLevel>=4) cout << argv[0] << ": here 4 " << endl;
	  v->getEvent(p->event());

	  if(printLevel>=4) cout << argv[0] << ": here 4a " << endl;
	  
	  e->releaseNewEvent();

	  if(printLevel>=4) cout << argv[0] << ": here 5 " << endl;

	  nTotal++;
	  nConfig++;
	}

	while(e->getNewEvent()==0);
	ConfigurationRecord *pe((ConfigurationRecord*)e->getNewEvent());
	
	pe->recordType(RecordBuffer::endOfConfiguration);
	pe->recordTime();
	pe->configurationNumber(d);
	pe->numberOfEvents(nTotal);
	pe->numberOfConfigurationEvents(nConfig);
	pe->numberOfShortWords();
	v->getConfiguration(pe->configuration());
	
	e->releaseNewEvent();
      }
      
      c->readerStatus(Control::changing);
      
      while(e->getNewEvent()==0);
      RunRecord *pe((RunRecord*)e->getNewEvent());
      
      pe->recordType(RecordBuffer::endOfRun);
      pe->recordTime();
      pe->runNumber(runNumber);
      pe->numberOfShortWords();
      
      e->releaseNewEvent();
      
      c->command(Control::stop);
      c->readerStatus(Control::stopped);
    }
    
    sleep(1);
  }
  
  cout << argv[0] << ": kill command seen" << endl;
  return 0;
}
