/***********************************************************************
 runWriter - makes run configuration files
***********************************************************************/

#include <fstream>
#include <iostream>

#include "Record.hh"

using namespace std;

main(int argc, char *argv[]) {
  ofstream fout("types/type001024.dat");

  unsigned array[2048];
  Record *r((Record*)array);
  r->deleteSubRecords();
  r->print(cout);

  unsigned rn(0);
  const unsigned nConfigurations(2);
  const unsigned nEvents(100);

  r->recordType(RecordHeader::startOfRun);
  r->recordTime(0);
  r->recordNumber(rn++);
  r->runNumber(0);
  r->runType(1024);
  r->numberOfConfigurations(nConfigurations);
  r->deleteSubRecords();
  r->print(cout);
  r->write(fout);
  
  for(unsigned i=0;i<nConfigurations;i++) {
    r->recordType(RecordHeader::startOfConfiguration);
    r->recordNumber(rn++);
    r->configurationNumber(i);
    r->configurationType(1024+i);
    r->numberOfEventsInConfiguration(nEvents);
    r->deleteSubRecords();

    SubRecord *s((SubRecord*)r->firstSubRecord());
    s->subRecordType(SubRecord::trigger);
    unsigned *d(s->firstWord());
    if(i==0) d[0]=0xdeadbeef;
    else     d[0]=0xfeedcafe;
    s->numberOfWords(1);
    r->addLastSubRecord(s);

    r->print(cout);
    r->write(fout);
  }

  return 0;
}
