/***********************************************************************
 socketClientCommander
 ***********************************************************************/

#include <iostream>

#include "Command.hh"
#include "ShmSingleton.hh"
#include "DuplexSocket.hh"

using namespace std;

main(int argc, char *argv[]) {
  /*
  ShmSingleton<Command> shmC;
  Command* c(shmC.payload());

  if(c==0) {
    cerr << "control: Null pointer for ShmSingleton<Command>" << endl;
    return 1;
  }

  cout << argv[0] << ": All shared memory attached" << endl;
  */
  Command comm;
  comm.reset();
  Command *c(&comm);

  DuplexSocket dSock("134.79.128.179",30000,1000); // pilsner
  cout << argv[0] << ": Client socket 1 initialised ";
  dSock.print(cout);
 
  char reply('x');

  while(true) {
    cout << "Enter: q(uit), r(un), s(top), k(ill) ";
    cin >> reply;
    
    if(reply=='q' || reply=='Q') {
      return 0;
    }
    
    if(reply=='k' || reply=='K') {
      if(c->command()==Command::run) {
	cout << "Cannot kill when running: stop first!!!" << endl;
      } else {
	c->command(Command::kill);
	dSock.send(c,1);
	dSock.recv(c,1);
	c->print(cout);
	return 0;
      }
    }

    if(reply=='r' || reply=='R') {
      if(c->command()==Command::run) {
	cout << "Already running!!!" << endl;
      } else {
	cout << "Enter run type (same as before = 0): ";
	unsigned n(0);
	cin >> n;
	if(n>0) c->runType(n);
	c->command(Command::run);
	dSock.send(c,1);
	dSock.recv(c,1);
	c->print(cout);
      }
    }

    if(reply=='s' || reply=='S') {
      if(c->command()==Command::stop) {
	cout << "Already stopped!!!" << endl;
      } else {
	c->command(Command::stop);
	dSock.send(c,1);
	dSock.recv(c,1);
	c->print(cout);
      }
    }
  }
}
