/***********************************************************************
 socketClientReader
 ***********************************************************************/

#include <cstdio>
#include <ctime>
#include <iostream>

#include "Record.hh"
#include "DuplexSocket.hh"

#include "RecordBuffer.hh"
#include "ShmSingleton.hh"


using namespace std;

main(int argc, char *argv[]) {
  unsigned printLevel(0);
  if(argc>1) sscanf(argv[1],"%u",&printLevel);
  cout << argv[0] << ": Print level set to " << printLevel << endl;

  unsigned servers(2);
  if(argc>2) sscanf(argv[2],"%u",&servers);
  cout << argv[0] << ": Servers set to 0x" << hex << servers << dec << endl;
  if((servers&3)==0) return 0;
  

  ShmSingleton<RecordBuffer> shmR;
  RecordBuffer* e(shmR.payload());

  if(e==0) {
    cerr << argv[0] << ": Null pointer for ShmSingleton<RecordBuffer>" << endl;
    return 1;
  }

  if(!e->setProducerPid()) {
    cerr << argv[0] << ": Another producer already registered with ShmSingleton<RecordBuffer>" << endl;
    return 1;
  }
  
  cout << argv[0] << ": All shared memory attached" << endl;

  try {
    //    DuplexSocket dSock("155.198.211.16",30001,1000); // lx09
    DuplexSocket dSock("134.79.128.179",30001,1000); // pilsner
    cout << argv[0] << ": Client socket 1 initialised ";
    dSock.print(cout);

    Record *r(0);
    int reply(456);
    while(r==0 || r->recordType()!=RecordHeader::shutDown) {
      while((r=e->getNewEvent())==0);
      int len=dSock.recv(r,1);

      if(r->recordType()!=RecordHeader::event) {
	cout << argv[0] << ": length " << len
	     << " received Record" << endl;
	r->print(cout);
      }

      e->releaseNewEvent();
      dSock.send(&reply,1);
    }

  } catch ( SocketException& e ) {
    cout << "Exception was caught: " << e.description() << endl;
  }

  e->zeroProducerPid();
  cout << "Exiting" << endl;
  
  return 0;
}
