// g++ -I../../../dual/inc/rcd -I../../../dual/inc/sub -I../../../dual/inc/daq -I../../inc/sem -I../../inc/skt -I../../inc/dio -I../../inc/onl socketReader.cc -o socketReader -lpthread

#include <unistd.h>
#include <cstdio>
#include <pthread.h>

#include <iostream>

#include "DioSocketConsumer.hh"
#include "DioThread.hh"
#include "OnlReader.hh"
#include "OnlSocketConsumer.hh"
#include "OnlDemerger.hh"

using namespace std;

int main() {
  OnlReader r(OnlReader::bin);
  r.open("driverFile");
  OnlSocketConsumer c(12330);

  DioThread<RcdArena> t0(r,c);
  t0.create();
  t0.join();

  return 0;
}
