/***********************************************************************
 controller
***********************************************************************/

#include <ctime>
#include <fstream>
#include <iostream>

#include "Record.hh"
#include "Command.hh"
#include "ShmSingleton.hh"
#include "SocketPorts.hh"
#include "ListenerSocket.hh"
#include "DuplexSocket.hh"

using namespace std;

unsigned readRunNumber() {
  ifstream fin("etc/runnumber.dat",ios::in);
  if(!fin) return 0;
  unsigned n(0);
  fin >> n;
  return n;
}

bool writeRunNumber(unsigned n) {
  ofstream fout("etc/runnumber.dat",ios::out);
  if(!fout) return false;
  fout << n << endl;
  return true;
}

main(int argc, char *argv[]) {
  unsigned printLevel(0);
  if(argc>1) sscanf(argv[1],"%u",&printLevel);
  cout << argv[0] << ": Print level set to " << printLevel << endl;

  ShmSingleton<Command> shmC;
  Command* c(shmC.payload());

  if(c==0) {
    cerr << argv[0] << ": Null pointer for ShmSingleton<Command>" << endl;
    return 1;
  }

  cout << argv[0] << ": All shared memory attached" << endl;

  unsigned runNo(readRunNumber());
  cout << argv[0] << ": Previous run number " << runNo << endl;

  bool reply(false);

  string ipNumber[3];
  ipNumber[0]="134.79.128.179"; // pilsner
  ipNumber[1]="134.79.113.171"; // marzen
  ipNumber[2]="134.79.112.73" ; // icstmpc1
  //"155.198.211.15"; // lx08
  //"155.198.211.16"; // lx09

  try {
    /*
    ListenerSocket lSock(READERPORT);
    cout << argv[0] << ": Listener socket initialised" << endl;
    lSock.print(cout);
    */

    DuplexSocket *dSock[3];
    unsigned nSock(3);
    if(argc>2) sscanf(argv[2],"%u",&nSock);
    cout << argv[0] << ": Number of sockets set to " << nSock << endl;

    unsigned iSock(0);
    for(iSock=0;iSock<nSock;iSock++) {
      //dSock[iSock]=new DuplexSocket(lSock);
      dSock[iSock]=new DuplexSocket(ipNumber[iSock],READERPORT,1000);
      cout << argv[0] << ": Server socket " << iSock << " initialised" << endl;
      dSock[iSock]->print(cout);
    }
    cout << argv[0] << ": All server sockets initialised" << endl;

    unsigned array[2048];
    Record *r((Record*)array);
    r->deleteSubRecords();
    r->print(cout);
    cout << flush;
    
    for(iSock=0;iSock<nSock;iSock++) dSock[iSock]->send(r,1);
    cout << argv[0] << ": StartUp send to all sockets" << endl;
    for(iSock=0;iSock<nSock;iSock++) dSock[iSock]->recv(&reply,1);
    cout << argv[0] << ": Reply received from all sockets" << endl;
    
    while(!(c->command() == Command::kill)) {
      if(c->command() == Command::run) {
	c->command(Command::null);

	string fileName("types/type000000.dat");
	if(c->runType()==1024) fileName="types/type001024.dat";
	if(c->runType()==1025) fileName="types/type001025.dat";
	if(c->runType()==1026) fileName="types/type001026.dat";
	
	ifstream fin(fileName.c_str());
	r->read(fin);
	r->print(cout);

	if(c->runType()!=0 && c->runType()!=r->runType()) {
	  cerr << argv[0] << ": Run type from file = " << r->runType()
	       << " does not match requested type = " << c->runType() << endl;
	} else {

	  runNo++; 
	  if(!writeRunNumber(runNo)) {
	    cerr << argv[0] << ": run number write failed" << endl;
	  } else {
	    cout << argv[0] << ": run number " << std::flush;
	    system("cat etc/runnumber.dat");
	  }

	  unsigned rn(0);
	  unsigned runTp(r->runType());
	  
	  r->recordTime(time(0));
	  r->recordNumber(rn++);
	  r->runNumber(runNo);
	  r->print(cout);

	  for(iSock=0;iSock<nSock;iSock++) dSock[iSock]->send(r,1);
	  for(iSock=0;iSock<nSock;iSock++) dSock[iSock]->recv(&reply,1);

	  unsigned nConfigurations(r->numberOfConfigurations());
	  unsigned en(0);
	  
	  if(c->command()!=Command::null) {
	    if(c->command()!=Command::run) {
	      cout << argv[0] << ": Stop run" << std::flush;
	      c->print(cout);

	      nConfigurations=0;

	      Record a;
	      a.recordType(RecordHeader::stopRun);
	      a.recordTime(time(0));
	      a.print(cout);
	      for(iSock=0;iSock<nSock;iSock++) dSock[iSock]->send(&a,1);
	      for(iSock=0;iSock<nSock;iSock++) dSock[iSock]->recv(&reply,1);
	    }
	    c->command(Command::null);
	  }

	  unsigned j(0);
	  for(j=0;j<nConfigurations;j++) {
	    r->read(fin);
	    r->print(cout);
	    
	    unsigned conTp(r->configurationType());
	  
	    r->recordTime(time(0));
	    r->recordNumber(rn++);
	    r->print(cout);
	  
	    for(iSock=0;iSock<nSock;iSock++) dSock[iSock]->send(r,1);
	    for(iSock=0;iSock<nSock;iSock++) dSock[iSock]->recv(&reply,1);
	    
	    unsigned nEvents(r->numberOfEvents());
	    unsigned es(0);
	    
	    /*
	      r->recordType(RecordHeader::startOfSpill);
	      r->recordTime(time(0));
	      r->recordNumber(rn++);
	      r->print(cout);
	      for(iSock=0;iSock<nSock;iSock++) dSock[iSock]->send(r,1);
	      for(iSock=0;iSock<nSock;iSock++) dSock[iSock]->recv(&reply,1);
	      es=0;
	    */
	    
	    if(c->command()!=Command::null) {
	      if(c->command()!=Command::run) {
		cout << argv[0] << ": Stop run" << std::flush;
		c->print(cout);

		nConfigurations=j+1;
		nEvents=0;

		Record a;
		a.recordType(RecordHeader::stopRun);
		a.recordTime(time(0));
		a.recordNumber(rn++);
		a.print(cout);
		for(iSock=0;iSock<nSock;iSock++) dSock[iSock]->send(&a,1);
		for(iSock=0;iSock<nSock;iSock++) dSock[iSock]->recv(&reply,1);
	      }
	      c->command(Command::null);
	    }
	    
	    r->recordType(RecordHeader::event);
	    for(unsigned i(0);i<nEvents;i++) {
	      r->recordTime(time(0));
	      r->recordNumber(rn++);
	      r->eventNumber(en++);
	      r->eventNumberInConfiguration(i);
	      r->eventNumberInSpill(es++);
	      /*
	      SubRecord *s(r->firstSubRecord());
	      unsigned *d(s->firstWord());
	      for(unsigned k(0);k<128;k++) d[k]=i*65536+k;
	      s->numberOfWords(128);
	      r->addLastSubRecord(s);
	      */
	      r->deleteSubRecords();
	      if((i%1000)==0) r->print(cout);

	      
	      for(iSock=0;iSock<nSock;iSock++) dSock[iSock]->send(r,1);
	      for(iSock=0;iSock<nSock;iSock++) dSock[iSock]->recv(&reply,1);
	      
	      if(c->command()!=Command::null) {
		if(c->command()!=Command::run) {
		  cout << argv[0] << ": Stop run" << std::flush;
		  c->print(cout);

		  nConfigurations=j+1;
		  nEvents=i+1;

		  Record a;
		  a.recordType(RecordHeader::stopRun);
		  a.recordTime(time(0));
		  a.recordNumber(rn++);
		  a.print(cout);
		  for(iSock=0;iSock<nSock;iSock++) dSock[iSock]->send(&a,1);
		  for(iSock=0;iSock<nSock;iSock++) dSock[iSock]->recv(&reply,1);
		}
		c->command(Command::null);
	      }
	    }
	    
	    /*
	      r.recordType(RecordHeader::endOfSpill);
	      r.recordTime(time(0));
	      r.recordNumber(rn++);
	      r.numberOfEvents(en++);
	      r.print(cout);
	      for(iSock=0;iSock<nSock;iSock++) dSock[iSock]->send(r,1);
	      for(iSock=0;iSock<nSock;iSock++) dSock[iSock]->recv(&reply,1);
	      es=0;
	    */
	    
	    r->recordType(RecordHeader::endOfConfiguration);
	    r->recordTime(time(0));
	    r->recordNumber(rn++);
	    r->configurationNumber(j);
	    r->configurationType(conTp);
	    r->numberOfEvents(nEvents);
	    r->deleteSubRecords();
	    r->print(cout);
	    
	    for(iSock=0;iSock<nSock;iSock++) dSock[iSock]->send(r,1);
	    for(iSock=0;iSock<nSock;iSock++) dSock[iSock]->recv(&reply,1);
	  }
	  
	  r->recordType(RecordHeader::endOfRun);
	  r->recordTime(time(0));
	  r->recordNumber(rn++);
	  r->runNumber(runNo);
	  r->runType(runTp);
	  r->numberOfConfigurations(nConfigurations);
	  r->deleteSubRecords();
	  r->print(cout);
	  
	  for(iSock=0;iSock<nSock;iSock++) dSock[iSock]->send(r,1);
	  for(iSock=0;iSock<nSock;iSock++) dSock[iSock]->recv(&reply,1);
	  c->command(Command::null);
	}
      }
      c->command(Command::null);
      sleep(1);
    }

    Record k;
    k.recordType(RecordHeader::shutDown);
    k.recordTime(time(0));
    k.print(cout);

    for(iSock=0;iSock<nSock;iSock++) dSock[iSock]->send(&k,1);
    for(iSock=0;iSock<nSock;iSock++) dSock[iSock]->recv(&reply,1);
    c->command(Command::null);

  } catch ( SocketException& e ) {
    cout << "Exception was caught: " << e.description() << endl;
  }

  cout << "Exiting" << endl;
  return 0;
}
