/***********************************************************************
 socketServerWriter
 ***********************************************************************/

#include <ctime>
#include <iostream>

#include "RecordBuffer.hh"
#include "ShmSingleton.hh"

#include "RecordHeader.hh"
#include "ListenerSocket.hh"
#include "DuplexSocket.hh"

using namespace std;

main(int argc, char *argv[]) {
  ShmSingleton<RecordBuffer> shmR;
  RecordBuffer* e(shmR.payload());

  if(e==0) {
    cerr << argv[0] << ": Null pointer for ShmSingleton<RecordBuffer>" << endl;
    return 1;
  }

  if(!e->setConsumerPid(argc>1)) {
    cerr << argv[0] << ": Another consumer already registered"
         << " with ShmSingleton<RecordBuffer>" << endl;
    return 1;
  } else {
    cout << argv[0] << ": Consumer registered"
         << " with ShmSingleton<RecordBuffer>" << endl;
    if(argc>1) return 0;
  }

  cout << argv[0] << ": All shared memory attached" << endl;

  try {
    ListenerSocket lSock(30002);
    cout << argv[0] << ": Listener socket initialised ";
    lSock.print(cout);

    DuplexSocket dSock(lSock);
    cout << argv[0] << ": Server socket initialised ";
    dSock.print(cout);

    int reply(0);
    while(!e->shutDown()) {
      Record *r(e->getOldEvent());
      if(r->recordType()!=RecordHeader::event) r->print(cout);
      dSock.send(r,1);
      dSock.recv(&reply,1);
      e->releaseOldEvent();
   }
    cout << argv[0] << ": kill command seen" << endl;

  } catch ( SocketException& e ) {
    std::cout << "Exception was caught:" << e.description() << "\nExiting.\n";
  }

  return 0;
}
