/***********************************************************************
 statusDirect
 ***********************************************************************/

#include <ctime>
#include <iostream>

#include "TimeVal.hh"
#include "StatusServer.hh"
#include "StatusClient.hh"
#include "BufferStatus.hh"
#include "RecordBuffer.hh"
#include "ShmSingleton.hh"
#include "SocketPorts.hh"
#include "ListenerSocket.hh"
#include "DuplexSocket.hh"


using namespace std;

main(int argc, char *argv[]) {
  time_t t;
  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Starting" << endl;

  StatusServer server;
  StatusClient client;
  const BufferStatus* const b(server.send());

  if(b==0) {
    cerr << argv[0] << " " << ctime(&(t=time(0)));
    cerr << " BufferStatus pointer is null" << endl;
    
  } else {
    while(!b->shutDown()) {
      TimeVal tv(true);
      cout << argv[0] << " " << tv << endl;
      client.recv(server.send());
      sleep(1);
    }
    cout << argv[0] << " " << ctime(&(t=time(0)));
    cout << " Shutdown command seen" << endl;
  }  

  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Exiting" << endl;
  return 0;
}
